import { findItemByVisIdAndPanelIndex } from './coat/find_item_by_vis_id_and_panel_index';
import { findMainNode } from './find_main_node';

// NOTE:
// Do not strip meta as we need it later
// E.g.: when constructing join filters we need to know which filters were negated
export function assignFiltersToCoat(treeItems, filters) {

  let mainNode;
  for (const filter of filters) {
    if (filter.meta && filter.meta._siren && filter.meta._siren.vis && filter.meta._siren.vis.id && filter.meta._siren.vis.panelIndex) {
      const filterNode = findItemByVisIdAndPanelIndex(treeItems, filter.meta._siren.vis.id, filter.meta._siren.vis.panelIndex);
      if (filterNode) {
        for (const item of treeItems) {
          if (item.type === 'node' && item.id === filterNode.id) {
            if (!item.d.entity.filters) {
              item.d.entity.filters = [];
            }
            item.d.entity.filters.push(filter);
          }
        }
      }
    } else {
      if (!mainNode) {
        mainNode = findMainNode(treeItems);
      }

      // if you cannot find it it is not accessible
      if (!mainNode) {
        return;
      }

      if (!mainNode.d.entity.filters) {
        mainNode.d.entity.filters = [];
      }

      mainNode.d.entity.filters.push(filter);
    }
  }
}
