const required = function () {
  return Promise.reject(
    new Error("Not Implemented!")
  );
};

export class AbstractOntologyModel {

  constructor(savedSearches, savedEids, indexPatterns, savedRelations) {
    const className = Object.getPrototypeOf(this).constructor.name;
    if (className === 'AbstractOntologyModel') {
      throw new TypeError('Abstract class "AbstractOntologyModel" cannot be instantiated directly.');
    }

    const methodsToImplement = [
      { f: this.getEntityList, name: 'getEntityList' },
      { f: this.getEntityMap, name: 'getEntityMap' },
      { f: this.getRelationList, name: 'getRelationList' },
      { f: this.getRelationMap, name: 'getRelationMap' },
      { f: this.getRelationsByDomain, name: 'getRelationsByDomain' },
      { f: this.getUniqueRelationLabels, name: 'getUniqueRelationLabels' },
      { f: this.getUniqueRelationLabelPairs, name: 'getUniqueRelationLabelPairs' },
      { f: this.getRangesForEntityId, name: 'getRangesForEntityId' },
      { f: this.getAllPaths, name: 'getAllPaths' },
      { f: this.clearCache, name: 'clearCache' }
    ];

    const methodsNotImplemented = methodsToImplement.filter(method => !method.f).map(method => method.name);

    if (methodsNotImplemented.length) {
      throw new TypeError(`Class '${className}' has unimplemented methods: ${methodsNotImplemented.join(', ')}`);
    }

    this.savedSearches = savedSearches;
    this.savedEids = savedEids;
    this.indexPatterns = indexPatterns;
    this.savedRelations = savedRelations;
  }
}
