import 'ui/kibi/directives/kibi_angular_qtip2';
import 'ui/kibi/directives/kibi_select_dashboard.less';
import { uiModules } from 'ui/modules';
import kibiUtils from 'kibiutils';
import _ from 'lodash';
import kibiSelectDashboardTemplate from 'ui/kibi/directives/kibi_select_dashboard.html';
import { SavedObjectsClientProvider } from 'ui/saved_objects';

uiModules.get('kibana')
  .directive('kibiSelectDashboard', function (Private, dashboardGroups) {

    return {
      require: 'ngModel',
      replace: true,
      scope: {
        multiSelect: '=?',
        dashboardArray: '=?',
        qtipTooltip: '=?',
        qtipOptions: '=?',
        titleLimit: '@?',
        disableMessage: '@?'
      },
      template: kibiSelectDashboardTemplate,
      link: function (scope, element, attrs, ngModelCtrl, kibiState) {

        let dashboardGroupList = [];
        // virtualGroups is used for displaying virtual groups as one group
        const virtualGroup = {
          title: 'Other',
          dashboards: []
        };

        const populateDashboardGroups = function () {
          const groups = dashboardGroups.getGroups();

          _.each(groups, function (group) {
            const groupItem = {};
            groupItem.dashboards = [];
            if (group.virtual) {
              virtualGroup.dashboards.push(group.dashboards[0]);
            } else {
              groupItem.title = group.title;
              groupItem.id = group.id;
              groupItem.dashboards = _.sortBy(group.dashboards, 'title');
              dashboardGroupList.push(groupItem);
            }
          });

          dashboardGroupList =  _.sortBy(dashboardGroupList, 'title');
          if (virtualGroup.dashboards.length > 0) {
            virtualGroup.dashboards = _.sortBy(virtualGroup.dashboards, 'title');
            return dashboardGroupList.concat(new Array(virtualGroup));
          } else {
            return dashboardGroupList;
          }
        };

        const savedObjectsClient = Private(SavedObjectsClientProvider);

        const populateDashboardGroupsFromSavedObjects = function () {
          const savedDashboardGroups = savedObjectsClient.find({
            type: 'dashboardgroup',
            fields: ['title'],
            perPage: 10000
          });
          const savedDashboards = savedObjectsClient.find({
            type: 'dashboard',
            fields: ['title'],
            perPage: 10000
          });
          return Promise.all([savedDashboardGroups, savedDashboards]).then(([grouped, dashboards]) => {
            const dashboardsById = {};
            dashboards.savedObjects.forEach(dash => {
              dashboardsById[dash.id] = {
                title: dash.attributes.title
              };
            });
            const dashboardsByGroup = [];
            grouped.savedObjects.forEach((group) => {
              const performedGroup = {};
              performedGroup.id = group.id;
              performedGroup.title = group.attributes.title;
              performedGroup.dashboards = JSON.parse(group.attributes.dashboards).map(dash => {
                dashboardsById[dash.id].grouped = true;
                return {
                  id: dash.id,
                  title: dashboardGroups._shortenDashboardName(group.attributes.title, dashboardsById[dash.id].title)
                };
              });
              dashboardsByGroup.push(performedGroup);
            });
            const dashboardGroupList = _.sortBy(dashboardsByGroup, 'title');
            const virtualGroup = [];
            _.each(dashboardsById, (dashOptions, dashId) => {
              if (!dashOptions.grouped) {
                virtualGroup.push({
                  id: dashId,
                  title: dashOptions.title
                });
              };
            });
            if (virtualGroup.length > 0) {
              dashboardGroupList.push({
                title: 'Other',
                dashboards: _.sortBy(virtualGroup, 'title')
              });
            };
            return dashboardGroupList;
          });
        };

        const _render = function   () {

          if (scope.dashboardArray) {
            scope.dashboardGroups = scope.dashboardArray;
          } else if (dashboardGroups.isInitialized) {
            scope.dashboardGroups = populateDashboardGroups();
          } else {
            populateDashboardGroupsFromSavedObjects().then(groupedDashboards => {
              scope.dashboardGroups = groupedDashboards;
              scope.$digest();
            });
          }
        };


        const _setViewValue = function (selectedDashboard) {
          if (selectedDashboard) {
            ngModelCtrl.$setViewValue(selectedDashboard);
          } else {
            ngModelCtrl.$setViewValue(null);
          }
        };

        scope.$watch('selectedDashboard', function (newValue, oldValue, myScope) {
          if (newValue) {
            _setViewValue(newValue);
          }
        }, true);

        function setModelObject() {
          scope.selectedDashboard = ngModelCtrl.$viewValue;
        }

        scope.$watch(
          function () {
            return ngModelCtrl.$modelValue;
          },
          setModelObject.bind(this)
        );
        setModelObject();

        // init
        _render(scope);
      }

    };
  });
