import { uiModules } from 'ui/modules';

uiModules
  .get('kibana')
  .directive('kibiStopClickEvent', function () {
    return {
      restrict: 'A',
      link: function ($scope, element, attr) {
        const stopPropagation = function (event) {
          event.stopPropagation();
        };

        element.on('click', stopPropagation);
        $scope.$on('$destroy', function () {
          element.off('click', stopPropagation);
        });
      }
    };
  });
