import chrome from 'ui/chrome';
import { uiModules } from 'ui/modules';
import template from './siren_filter_date_field_format_help.html';
import { documentationLinks } from 'ui/documentation_links/documentation_links';

const module = uiModules.get('kibana');
module.directive('sirenFilterDateFieldFormatHelp', function (es, $http) {
  return {
    restrict: 'E',
    template,
    scope: {
      field: '='
    },
    link: function (scope) {
      scope.dateDocLinks = documentationLinks.date;

      $http.get(chrome.getBasePath() + '/connector_elasticsearch/_siren/connector/index/_search')
        .then(response => response.data.hits.hits.map(virtualIndex => virtualIndex._id))
        .then(virtualIndices => scope.isVirtualIndex = virtualIndices.includes(scope.field.indexPattern.title));

      es.search({
        index: scope.field.indexPattern.title,
        body: {
          size: 1,
          query: {
            exists: {
              field: scope.field.name
            }
          }
        }
      })
        .then(response => response.hits.hits[0]._source[scope.field.name])
        .then(date => scope.date = date);

      scope.getDefaultFormat = () => {
        if (scope.isVirtualIndex) {
          return 'yyyy/MM/dd HH:mm:ss||yyyy/MM/dd||epoch_millis';
        } else if (scope.isVirtualIndex === false) {
          return 'strict_date_optional_time||epoch_millis';
        }
      };

      scope.getMappingFormat = () => (scope.field.mappingFormat || scope.getDefaultFormat()).split('||');
    }
  };
});
