const $ = require('jquery');
export class SirenEntityNavResizeHelper {
  constructor(container) {
    const sidebarContainer = document.getElementsByClassName('sidebar-container')[0];

    let contentWrapper;
    if (container && sidebarContainer) {
      contentWrapper = document.getElementsByClassName(container)[0];
      if (container === 'siren-entity-editor-container' && !contentWrapper) {
        contentWrapper = $('.data-model .col-md-10').not('.ng-hide')[0];
      };
    } else {
      return;
    };

    function updateSidebarWidth(event) {
      const MAX_SIDEBAR_SIZE = 500;
      const MIN_SIDEBAR_SIZE = 180;
      const navBarSize = sidebarContainer.getBoundingClientRect().x;
      const newSidebarContainerWidth = event.pageX - navBarSize;
      if (
        newSidebarContainerWidth > MAX_SIDEBAR_SIZE
        || newSidebarContainerWidth < MIN_SIDEBAR_SIZE
      ) {
        return;
      };
      sidebarContainer.style.width = newSidebarContainerWidth + 'px';
      contentWrapper.style.width = 'calc(100% - ' + newSidebarContainerWidth + 'px)';
      contentWrapper.style.cursor = 'col-resize';
      contentWrapper.setAttribute('siren-resize', true);
    };

    function mouseMoveHandler(event) {
      const AVAILABLE_RESIZE_ZONE = 5;
      const sidebarContainerWidth = sidebarContainer.offsetWidth;
      const sidebarContainerPosition = sidebarContainer.getBoundingClientRect();
      const navBarSize = sidebarContainerPosition.x;
      const cursorLimit = sidebarContainerWidth + navBarSize - event.pageX;

      if (cursorLimit < AVAILABLE_RESIZE_ZONE && cursorLimit > 0) {
        sidebarContainer.style.cursor = 'col-resize';
        sidebarContainer.style.boxShadow = '3px 0px 0px 0px rgba(0,0,0,0.4)';
        sidebarContainer.addEventListener('mousedown', mouseDownHandler);
        sidebarContainer.addEventListener('mouseleave', mouseLeaveHandler);
      } else {
        sidebarContainer.style.cursor = '';
        sidebarContainer.style.boxShadow = '';
        sidebarContainer.removeEventListener('mousedown', mouseDownHandler);
      }
    };

    function activateSidebarResize() {
      sidebarContainer.removeEventListener('mouseleave', mouseLeaveHandler);
      sidebarContainer.removeEventListener('mousemove', mouseMoveHandler);
      sidebarContainer.addEventListener('click', removeSidebarResizeListeners);
      sidebarContainer.style.boxShadow = '3px 0px 0px 0px rgba(0,0,0,0.4)';
      document.addEventListener('mousemove', makeSidebarResize);
    };

    function mouseDownHandler(event) {
      if (event.which !== 1 || event.target.closest('button')) {
        return;
      };
      event.preventDefault();
      activateSidebarResize();
    }

    function makeSidebarResize(event) {
      event.preventDefault();
      updateSidebarWidth(event);
      document.addEventListener('mouseup', removeSidebarResizeListeners);
    }

    function removeSidebarResizeListeners() {
      sidebarContainer.addEventListener('mousemove', mouseMoveHandler);
      sidebarContainer.removeEventListener('mousedown', mouseDownHandler);
      sidebarContainer.style.boxShadow = '';
      document.removeEventListener('mousemove', makeSidebarResize);
      document.removeEventListener('mouseup', removeSidebarResizeListeners);
      sidebarContainer.removeEventListener('click', removeSidebarResizeListeners);
      contentWrapper.style.cursor = '';
    }

    function mouseLeaveHandler() {
      sidebarContainer.style.boxShadow = '';
    }

    sidebarContainer.addEventListener('mousemove', mouseMoveHandler);

    this.destroy = () => {
      if (!sidebarContainer) {
        return;
      };
      sidebarContainer.removeEventListener('mouseleave', mouseLeaveHandler);
      sidebarContainer.removeEventListener('mousemove', mouseMoveHandler);
    };
  }
}