import { IndexPatternMissingIndices, IndexPatternAuthorizationError } from 'ui/errors';
import _ from 'lodash';


// Handles an error. If we get an authorization error and the returnObject is set,
// we will silently ignore the error and return the object instead (typically an empty object).
module.exports = function (err, indexPattern, returnObject) {
  // kibi: handle authorization errors
  if (err.status === 403 && returnObject) {
    return Promise.resolve(returnObject);
  } else if (err.status === 403) {
    return Promise.reject(new IndexPatternAuthorizationError(indexPattern));
  } else if (err.status >= 400) {
    let message = err.message;
    // kibi: be more specific for 500 from jdbc datasources
    if (err.status === 500 && _.get(err, 'body.error.caused_by.reason')) {
      message = err.body.error.caused_by.reason;
    }
    // kibi: end
    // transform specific error type
    return Promise.reject(new IndexPatternMissingIndices(message));
  } else {
    // rethrow all others
    throw err;
  }
};
