import { ModalOverlay } from 'ui/modals/modal_overlay';

import angular from 'angular';


export function BaseModalProvider($rootScope, $compile, $timeout) {

  const $documentBody = angular.element(document.body);

  function bindEscKey(scope) {
    scope.onEscKey = scope.onEscKey || function () {
      scope.onCancel();
    };

    scope.onKey = scope.onKey || function (event) {
      if (event.keyCode === 27) { scope.onEscKey(); }
    };

    $documentBody.on('keydown', scope.onKey);
  }

  return function baseModalPromise(template, scopeData) {
    const scope = Object.assign($rootScope.$new(), scopeData, {
      onConfirm(result) {
        const { resolve } = scope;

        if (!resolve) { return; }
        scope.resolve = null;

        $documentBody.off('keydown', scope.onKey);
        scope.deregisterLocChangeCb();

        scope.modal.destroy();
        scope.$destroy();

        resolve(result);
      },

      onCancel() {
        scope.onConfirm(null);
      }
    });

    return {
      scope,

      show() {
        return this.waitForClose = new Promise(resolve => {
          const modalWindow = $compile(template)(scope);

          this.waitForVisible = $timeout(() => {                // Wait element rendering
            scope.resolve = resolve;
            scope.deregisterLocChangeCb = $rootScope
              .$on('$locationChangeStart', scope.onCancel);

            scope.modal = new ModalOverlay(modalWindow);        // Spawns the modal
            if (scope.overlayClass) {
              scope.modal.overlayElement.addClass(scope.overlayClass);
            }

            bindEscKey(scope);
          });
        });
      }
    };
  };
}
