import _ from 'lodash';

const throwDeprecationError = function () {
  throw new Error('Saved Objects now have: id, type and attribute properties' +
  ' instead of _id, _type and _source');
};
export class SavedObject {
  constructor(client, { id, type, version, attributes, error } = {}) {
    this._client = client;
    this.id = id;
    this.type = type;
    this.attributes = attributes || {};
    this._version = version;
    this.error = error;
  }

  get _id() {
    throwDeprecationError();
  }

  get _type() {
    throwDeprecationError();
  }

  get _source() {
    throwDeprecationError();
  }

  get(key) {
    return _.get(this.attributes, key);
  }

  set(key, value) {
    return _.set(this.attributes, key, value);
  }

  has(key) {
    return _.has(this.attributes, key);
  }

  save() {
    if (this.id) {
      return this._client.update(this.type, this.id, this.attributes);
    } else {
      return this._client.create(this.type, this.attributes);
    }
  }

  delete() {
    // TODO first check for permissions
    return this._client.delete(this.type, this.id);
  }
}
