import _ from 'lodash';
import moment from 'moment';
import { buildRangeFilter } from 'ui/filter_manager/lib/range';
import { coatHelper } from 'ui/kibi/components/dashboards360/coat_helper';

// kibi: Please do NOT use parseWithPrecision here since the filter should be exactly what the user selected
export function UtilsBrushEventProvider(timefilter) {
  return $state => {
    return event => {
      if (!event.data.xAxisField) {
        return;
      }

      const isDate = event.data.xAxisField.type === 'date';
      const isNumber = event.data.xAxisField.type === 'number';
      const xFieldMatches = event.data.xAxisField.name === event.data.indexPattern.timeFieldName;

      // Note:
      // if it is not assigned to coat tree we assume we should act like it would be assigned to main node
      let isMainVisualization = true;
      let useGlobalTimeFilter = true;

      if (event.data._siren) {
        const node = coatHelper.findItemByVisIdAndPanelIndex(
          event.data._siren.coat.items,
          event.data._siren.vis.id,
          event.data._siren.vis.panelIndex
        );
        isMainVisualization = node && node.d && node.d.isRoot;
        useGlobalTimeFilter = node && node.d && node.d.entity.useGlobalTimeFilter;
      }

      // Note:
      if (isDate && xFieldMatches && isMainVisualization && useGlobalTimeFilter) {
        setTimefilter();
      } else if (isDate || isNumber) {
        setRange();
      }

      function setTimefilter() {
        const from = moment(event.range[0]);
        const to = moment(event.range[1]);

        if (to - from === 0) return;

        timefilter.time.from = from;
        timefilter.time.to = to;
        timefilter.time.mode = 'absolute';
      }

      function setRange() {
        // kibi: #5812 added condition event.range.length === 1 for correct behaviour on selecting
        if (event.range.length === 0) return;

        const existingFilter = $state.filters.find(filter => (
          filter.meta && filter.meta.key === event.data.xAxisField.name
        ));

        const min = event.range[0];
        const max = event.range.length === 1 ? event.range[0] : event.range[event.range.length - 1]; // kibi: #5812 added condition
        let range;
        if (isDate) {
          range = {
            gte: moment(min).valueOf(),
            lte: moment(max).valueOf(), //kibi: #5812 lt -> lte
            format: 'epoch_millis'
          };
        } else {
          range = {
            gte: min,
            lte: max //kibi: #5812 lt -> lte
          };
        }

        if (_.has(existingFilter, 'range')) {
          existingFilter.range[event.data.xAxisField.name] = range;
        } else if (_.has(existingFilter, 'script.script.params.gte')
          && _.has(existingFilter, 'script.script.params.lt')) {
          existingFilter.script.script.params.gte = min;
          existingFilter.script.script.params.lt = max;
        } else {
          const newFilter = buildRangeFilter(
            event.data.xAxisField,
            range,
            event.data.indexPattern,
            event.data.xAxisFormatter,
            event.data._siren);
          $state.$newFilters = [newFilter];
        }
      }
    };
  };
}
