"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAttachment = getAttachment;
const graph_functions_1 = require("./graph_functions");
const serialize_graph_1 = require("./serialize_graph");
async function getAttachment() {
    const [graphModel, openedGraph] = await Promise.all([
        (0, graph_functions_1.getGraphFunction)('getGraphModel')?.(),
        (0, graph_functions_1.getGraphFunction)('getOpenedGraph')?.()
    ]);
    if (graphModel && openedGraph) {
        return ({
            id: openedGraph.getId(),
            title: openedGraph.getLabel(),
            model: await (0, serialize_graph_1.serializeGraphModel)(graphModel)
        });
    }
}
