"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processingPluginList = exports.parsingPluginList = void 0;
const eui_1 = require("@elastic/eui");
const node_reference_parser_1 = require("./node_reference_parser");
const node_reference_renderer_1 = require("./node_reference_renderer");
const parsingMarkdownPlugins = (0, eui_1.getDefaultEuiMarkdownParsingPlugins)();
for (const plugin of parsingMarkdownPlugins) {
    if (plugin[1]?.emoticon) {
        plugin[1].emoticon = false;
    }
}
exports.parsingPluginList = [
    ...parsingMarkdownPlugins,
    node_reference_parser_1.nodeReferenceParser
];
exports.processingPluginList = (0, eui_1.getDefaultEuiMarkdownProcessingPlugins)();
exports.processingPluginList[1][1].components.nodeReferencePlugin = node_reference_renderer_1.NodeReferenceRenderer;
