"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeReferenceRenderer = NodeReferenceRenderer;
const react_1 = __importStar(require("react"));
const eui_1 = require("@elastic/eui");
// @ts-ignore
const ng_injector_1 = require("ui/ng_injector");
// @ts-ignore
const data_record_1 = require("../../../../../src/siren_core_plugins/scripting/public/v1/data_record");
// @ts-ignore
const data_model_entity_1 = require("../../../../../src/siren_core_plugins/scripting/public/v1/data_model_entity");
const graph_functions_1 = require("../graph_functions");
function NodeReferenceRenderer({ index, id, label, entityId, entityType, isLocalNode }) {
    const handleNodeClick = (0, react_1.useCallback)(async () => {
        const Private = (0, ng_injector_1.getNgService)('Private');
        const DataRecord = Private(data_record_1.DataRecordProvider);
        const DataModelEntityClass = Private(data_model_entity_1.DataModelEntityProvider);
        const selectNodes = (0, graph_functions_1.getGraphFunction)('selection');
        const getOpenedGraph = (0, graph_functions_1.getGraphFunction)('getOpenedGraph');
        const isSearchNode = entityType === 'search';
        if (await getOpenedGraph?.()) {
            let nodeId;
            if (isLocalNode) {
                nodeId = id;
            }
            else {
                nodeId = entityType === 'search' ? `${index}/_doc/${id}` : id;
            }
            selectNodes?.([nodeId]);
        }
        if (!isLocalNode) {
            const dataModelEntity = await DataModelEntityClass.getDataModelEntityById(entityId);
            const dataRecord = isSearchNode ? DataRecord.makeSearchRecord({ _index: index, _id: id }, [dataModelEntity])
                : DataRecord.makeEidRecord(label, dataModelEntity);
            if (dataRecord) {
                void dataRecord.openRecordViewer();
            }
        }
    }, [entityType, entityId, isLocalNode, id, index, label]);
    return (react_1.default.createElement(eui_1.EuiBadge, { color: "hollow", iconType: "popout", iconSide: "right", onClick: handleNodeClick, onClickAriaLabel: `Open record for ${label}`, "data-test-subj": "k9-es-doc-id-badge" }, label));
}
