"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useChat = useChat;
const moment_1 = __importDefault(require("moment"));
const react_1 = require("react");
const axios_1 = require("axios");
// @ts-ignore
const ng_injector_1 = require("ui/ng_injector");
const types_1 = require("../../common/types");
const get_advanced_settings_1 = require("../../server/setup/get_advanced_settings");
const api = __importStar(require("./api"));
const notifier_1 = require("./notifier");
const execute_tools_1 = require("./execute_tools");
function useChat() {
    const [messages, setMessages] = (0, react_1.useState)(() => JSON.parse(sessionStorage.getItem('k9ChatHistory') || '[]'));
    const [loading, setLoading] = (0, react_1.useState)(false);
    const cancelRef = (0, react_1.useRef)(undefined);
    (0, react_1.useEffect)(() => {
        sessionStorage.setItem('k9ChatHistory', JSON.stringify(messages));
    }, [messages]);
    async function sendMessage(content, attachment) {
        const processedMessages = attachment ? removeAttachmentData(messages) : messages;
        const updatedMessages = [
            ...processedMessages,
            { type: 'message', user: types_1.User.You, content, timestamp: (0, moment_1.default)().toISOString(), attachment }
        ];
        setMessages(updatedMessages);
        setLoading(true);
        try {
            await sendMessages(updatedMessages);
        }
        catch (e) {
            if (!(e instanceof axios_1.CanceledError)) {
                console.error(e);
                notifier_1.notify.error('An error occurred getting a response from K9: Try reducing the size of the message.');
                setMessages(prev => [...prev, getErrorMessage(!!attachment)]);
            }
        }
        finally {
            cancelRef.current = undefined;
            setLoading(false);
        }
    }
    async function sendMessages(messages) {
        const userSystemPrompt = (0, ng_injector_1.getNgService)('config').get(get_advanced_settings_1.AdvancedSettings.K9_CHAT_PROMPT) || undefined;
        const operation = api.sendMessages(messages, { responseFormat: 'markdown', userSystemPrompt });
        cancelRef.current = operation.cancel;
        const llmOutputs = await operation.promise;
        setMessages([...messages, ...llmOutputs]);
        const toolCalls = llmOutputs.filter(output => output.type === 'function_call');
        if (toolCalls.length) {
            const toolCallResponses = await (0, execute_tools_1.executeToolCalls)(toolCalls);
            const messagesWithToolResponses = [...messages, ...llmOutputs, ...toolCallResponses];
            setMessages(messagesWithToolResponses);
            await sendMessages(messagesWithToolResponses);
        }
    }
    const cancel = (0, react_1.useCallback)(() => {
        if (cancelRef.current) {
            cancelRef.current();
            setMessages(prev => [...prev, getCancelledMessage()]);
        }
    }, [setMessages]);
    const startNew = (0, react_1.useCallback)(() => {
        cancelRef.current?.();
        setMessages([]);
    }, [setMessages]);
    return { messages, loading, sendMessage, startNew, cancel };
}
function removeAttachmentData(messages) {
    return messages.map(message => {
        if (message.type === 'message' && message.user === types_1.User.You && message.attachment?.model) {
            return {
                ...message,
                attachment: {
                    ...message.attachment,
                    model: ''
                }
            };
        }
        else {
            return message;
        }
    });
}
function getAttachmentError() {
    return `The graph is too large to process. Try reducing the size by 
  creating another graph as a subset or removing unnecessary nodes.`;
}
function getLimitError() {
    return `
**Error: Message Rate Limit or Size Issue**

Possible solutions:

1. Shorten your content or split it into smaller parts.
2. If the conversation is long, start a fresh chat to help reset limits.
3. If a graph is attached, try simplifying it by reducing the number of nodes or edges, or create a new graph with a smaller selection.
4. Retry later.
  `;
}
function getCancelledMessage() {
    return {
        type: 'message',
        user: types_1.User.K9,
        timestamp: (0, moment_1.default)().toISOString(),
        content: '_Response generation was interrupted. Please send a new question to continue._'
    };
}
function getErrorMessage(haveAttachment) {
    return {
        type: 'message',
        user: types_1.User.K9,
        timestamp: (0, moment_1.default)().toISOString(),
        content: getLimitError(),
        ...(haveAttachment && { errors: { attachment: getAttachmentError() } })
    };
}
