/** Note: Do notimport types from other files. */

export declare global {
  export namespace Siren {
    interface SirenApiExtensions {
      GenerativeAi: typeof GenerativeAi;
    }
  }
}

declare class GenerativeAi {
  public static sendPrompt(message: Message, options?: { contextId?: string }): Promise<{ data: string; contextId: string }>;
  public static generateGraphReport(
    graphModel: GraphModel,
    options?: { focusNodes?: string[]; customPrompt?: string }
  ): Promise<{ content: string }>;
}

interface Message {
  user: User;
  /** ISO format */
  timestamp: string;
  /** Formatted in Markdown */
  content: string;
}

enum User {
  K9 = 'K9',
  You = 'You',
}

interface GraphModel {
  nodes: Node[];
  edges: Edge[];
}

interface Node {
  id: string;
  siren: {
    entityId: string;
    indexPattern?: string;
    d: Record<string, unknown>;
  };
  style: {
    label: {
      value: string;
    };
  };
}

interface Edge {
  source: string;
  target: string;
  style: {
    label: {
      value: string;
    };
  };
}
