"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isLocalNode = isLocalNode;
exports.isNormalSearchNode = isNormalSearchNode;
exports.isEidNode = isEidNode;
exports.isNormalEdge = isNormalEdge;
exports.isLocalEdge = isLocalEdge;
exports.isAggregatedEdge = isAggregatedEdge;
// @ts-ignore
const types_1 = require("../../../src/siren_core_plugins/graph_browser/public/types");
function isLocalNode(node) {
    return 'isLocal' in node.siren && node.siren.isLocal;
}
function isNormalSearchNode(node) {
    return !isLocalNode(node) && (0, types_1.isSearchNode)(node.siren.entityId);
}
function isEidNode(node) {
    return !isLocalNode(node) && 'eidValue' in node.siren && !!node.siren.eidValue;
}
function isNormalEdge(edge) {
    return !isLocalEdge(edge) && 'relId' in edge.siren && !!edge.siren.relId;
}
function isLocalEdge(edge) {
    return 'isLocal' in edge.siren && !!edge.siren.isLocal;
}
function isAggregatedEdge(edge) {
    return 'd' in edge.siren && !!edge.siren.d && 'docCount' in edge.siren.d;
}
