"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChatSystemMessage = getChatSystemMessage;
const promises_1 = require("node:fs/promises");
const path_1 = require("path");
let chatSystemMessage;
const RESPONSE_FORMAT_TO_MESSAGE = {
    text: '',
    html: 'Your complete response should be returned as a HTML snippet and must start with <div>',
    markdown: 'Your complete response be returned as Markdown'
};
async function getChatSystemMessage(responseFormat) {
    if (!chatSystemMessage) {
        chatSystemMessage = await (0, promises_1.readFile)((0, path_1.join)(__dirname, 'chat_system_message.md'), 'utf8');
    }
    return {
        type: 'message',
        role: 'system',
        content: `
      ${chatSystemMessage}

      ${RESPONSE_FORMAT_TO_MESSAGE[responseFormat || 'text']}
    `
    };
}
