"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getGraphSystemMessage = getGraphSystemMessage;
const promises_1 = require("node:fs/promises");
const node_path_1 = require("node:path");
let graphSystemMessage;
async function getGraphSystemMessage() {
    if (!graphSystemMessage) {
        graphSystemMessage = await (0, promises_1.readFile)((0, node_path_1.join)(__dirname, 'graph_system_message.md'), 'utf8');
    }
    return {
        type: 'message',
        role: 'system',
        content: graphSystemMessage
    };
}
