"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createReportGeneratorScript = createReportGeneratorScript;
const fs_1 = require("fs");
const path_1 = require("path");
// @ts-ignore
// eslint-disable-next-line import/no-unresolved
const versions_1 = require("../../../../src/server/saved_objects/routes/common/versions");
const SCRIPT_ID = 'sirenapiscript:e82cc510-d1a2-11ef-856c-f546f18e4d09';
async function createReportGeneratorScript(server) {
    const script = {
        type: 'custom',
        title: 'AI graph report generator script',
        description: '',
        scriptSource: (0, fs_1.readFileSync)((0, path_1.join)(__dirname, 'scripts/graph_report_script.tsx')).toString(),
        scriptTypeVersion: 1,
        apiVersion: 1,
        version: (0, versions_1.getMostRecentVersion)('sirenapiscript'),
    };
    const savedObjectsClient = server.savedObjectsClientFactory();
    await savedObjectsClient.create('sirenapiscript', script, { id: SCRIPT_ID, overwrite: true }, server.getServerRequest());
    server.plugins.import_export_helper.registerImmutableObjectId(SCRIPT_ID);
}
