"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.uiContexts = exports.SirenAiContexts = void 0;
exports.registerUiContexts = registerUiContexts;
var SirenAiContexts;
(function (SirenAiContexts) {
    SirenAiContexts["LLM_ACCESES_PERMISSION"] = "ui:kibi@siren_ai_llm_access_permission";
    SirenAiContexts["LLM_CHAT_ACCESS"] = "ui:kibi@siren_ai_llm_chat_permission";
})(SirenAiContexts || (exports.SirenAiContexts = SirenAiContexts = {}));
exports.uiContexts = [{
        id: SirenAiContexts.LLM_ACCESES_PERMISSION,
        title: 'Access to Siren AI endpoints',
        description: 'Block/Allow access to Siren AI endpoints'
    },
    {
        id: SirenAiContexts.LLM_CHAT_ACCESS,
        title: 'Access to K9 - Siren AI assistant',
        description: 'Block/Allow access to K9 AI assistant'
    }];
async function registerUiContexts(server) {
    const config = server.config();
    const aclEnabled = config.get('investigate_access_control.enabled')
        && config.get('investigate_access_control.acl.enabled');
    if (aclEnabled && server.plugins.investigate_access_control) {
        server.plugins.investigate_access_control.registerUiContexts(exports.uiContexts);
    }
}
