"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = default_1;
const routes_1 = require("./server/routes");
const azure_openai_1 = require("./server/ai_client/providers/azure_openai");
const openai_1 = require("./server/ai_client/providers/openai");
const ollama_1 = require("./server/ai_client/providers/ollama");
const aws_bedrock_1 = require("./server/ai_client/providers/aws_bedrock");
const create_report_generator_script_1 = require("./server/setup/create_report_generator_script");
const register_ui_contexts_1 = require("./server/setup/register_ui_contexts");
const get_advanced_settings_1 = require("./server/setup/get_advanced_settings");
function default_1(kibana) {
    return new kibana.Plugin({
        require: ['kibana', 'investigate_access_control', 'elasticsearch', 'investigate_core', 'import_export_helper'],
        config: Joi => Joi.object({
            enabled: Joi.boolean().default(true),
            provider: Joi.string().valid('azure', 'openai', 'ollama', 'aws').required(),
            providerConfig: Joi.object({
                azure: Joi.when('...provider', { is: 'azure', then: azure_openai_1.AzureConfigSchema.required() }),
                openai: Joi.when('...provider', { is: 'openai', then: openai_1.OpenAiConfigSchema.required() }),
                ollama: Joi.when('...provider', { is: 'ollama', then: ollama_1.OllamaConfigSchema.required() }),
                aws: Joi.when('...provider', { is: 'aws', then: aws_bedrock_1.AwsBedrockConfigSchema.required() })
            }).default(),
            _dev: Joi.when('$prod', {
                is: true,
                then: Joi.forbidden(),
                otherwise: Joi.object({
                    mockLlmResponses: Joi.boolean().default(false)
                }).default()
            }),
        }),
        uiExports: {
            chromeNavControls: ['plugins/siren-ai/k9_companion/sidebar_button.js'],
            sirenApiExtension: ['plugins/siren-ai/sirenapi/register_extension.js'],
            uiSettingDefaults: { ...(0, get_advanced_settings_1.getAdvancedSettings)() }
        },
        async init(server) {
            await (0, register_ui_contexts_1.registerUiContexts)(server);
            (0, routes_1.registerApiRoutes)(server);
            await (0, create_report_generator_script_1.createReportGeneratorScript)(server);
        }
    });
}
