"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.K9Companion = K9Companion;
const react_1 = __importStar(require("react"));
const eui_1 = require("@elastic/eui");
const use_chat_1 = require("../lib/use_chat");
const chat_window_1 = require("./chat_window");
const k9_icon_1 = require("./k9_icon");
require("./style.css");
function K9Companion() {
    const [isOpen, setIsOpen] = (0, react_1.useState)(false);
    const { messages, loading, sendMessage, startNew, cancel } = (0, use_chat_1.useChat)();
    (0, react_1.useEffect)(() => {
        window.addEventListener('beforeunload', cancel);
        return () => window.removeEventListener('beforeunload', cancel);
    }, [cancel]);
    return (react_1.default.createElement(eui_1.EuiPopover, { button: react_1.default.createElement(SidebarButton, { onClick: () => setIsOpen(isOpen => !isOpen) }), isOpen: isOpen, closePopover: () => setIsOpen(false), anchorPosition: "rightCenter", panelPaddingSize: "s", initialFocus: "#message-input" },
        react_1.default.createElement(chat_window_1.ChatWindow, { messages: messages, loadingNextMessage: loading, onSendMessage: sendMessage, onStartNewConversation: startNew, onCancelMessage: cancel })));
}
function SidebarButton({ onClick }) {
    return (react_1.default.createElement("div", { onClick: onClick, className: "global-nav-link navbar-button", style: { padding: '0' } },
        react_1.default.createElement("div", { className: "global-nav-link__icon" },
            react_1.default.createElement(k9_icon_1.K9Icon, { className: "global-nav-link__icon-image", isWhite: true, filled: true })),
        react_1.default.createElement("div", { className: "global-nav-link__title" }, "K9 companion")));
}
