"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageHistory = MessageHistory;
const moment_1 = __importDefault(require("moment"));
const react_1 = __importStar(require("react"));
const eui_1 = require("@elastic/eui");
// @ts-ignore
const chrome = __importStar(require("ui/chrome"));
// @ts-ignore
const ng_injector_1 = require("ui/ng_injector");
// @ts-ignore
const visualizer_helper_1 = require("../../../../src/core_plugins/kibana/public/dashboard/visualizer/visualizer_helper");
const types_1 = require("../../common/types");
const markdown_plugins_1 = require("../lib/markdown_parsers/markdown_plugins");
const k9_icon_1 = require("./k9_icon");
function MessageHistory({ messages, loadingNextMessage, onStopNextMessage }) {
    const ref = (0, react_1.useRef)(null);
    const [existingGraphIds, setExistingGraphIds] = (0, react_1.useState)(new Set());
    (0, react_1.useEffect)(() => {
        ref.current?.scrollTo({ top: ref.current?.scrollHeight, behavior: 'instant' });
    }, [messages, loadingNextMessage]);
    (0, react_1.useEffect)(() => {
        const fetchExistingGraphs = async () => {
            if (messages.some(message => message.type === 'message' && message.user === types_1.User.You && !!message.attachment)) {
                const savedGraphs = (0, ng_injector_1.getNgService)('savedGraphs');
                const graphs = await savedGraphs.findRaw({ lightweight: true });
                setExistingGraphIds(new Set(graphs.hits.map(hit => hit.id)));
            }
        };
        void fetchExistingGraphs();
    }, [messages]);
    const messagesToRender = (0, react_1.useMemo)(() => {
        const dateFormat = (0, ng_injector_1.getNgService)('config').get('dateFormat');
        const messagesToRender = messages
            .filter(message => message.type === 'message' || message.type === 'function_call')
            .map((message, index, messages) => {
            if (message.type === 'message') {
                const prevMessage = messages.findLast((m, i) => i < index && m.type === 'message');
                const prevMessageAttachment = prevMessage?.user === types_1.User.You ? prevMessage?.attachment : undefined;
                const attachmentExist = prevMessageAttachment && existingGraphIds.has(prevMessageAttachment.id);
                const options = { dateFormat, respondingToAttachment: prevMessageAttachment, disableAttachment: !attachmentExist };
                return messageToComment(message, options);
            }
            else {
                return messageToComment(message, { dateFormat });
            }
        });
        if (loadingNextMessage) {
            const prevMessage = messages.findLast(message => message.type === 'message');
            messagesToRender.push({
                username: types_1.User.K9,
                type: 'regular',
                timestamp: '...',
                timelineIcon: getTimelineIcon(types_1.User.K9),
                children: (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement(AttachmentBadge, { attachment: prevMessage?.user === types_1.User.You ? prevMessage.attachment : undefined }),
                    react_1.default.createElement(eui_1.EuiLoadingContent, { lines: 3 })))
            });
        }
        return messagesToRender;
    }, [loadingNextMessage, messages, existingGraphIds]);
    if (!messages.length) {
        return react_1.default.createElement(NoMessagesPrompt, null);
    }
    return (react_1.default.createElement("div", { ref: ref, className: "message-history" },
        react_1.default.createElement(eui_1.EuiCommentList, { comments: messagesToRender }),
        loadingNextMessage && (react_1.default.createElement("div", { style: { display: 'flex', justifyContent: 'center' } },
            react_1.default.createElement(eui_1.EuiButtonEmpty, { color: "text", iconType: "stopFilled", onClick: onStopNextMessage, "data-test-subj": "stop-generation" }, "Stop generation")))));
}
function NoMessagesPrompt() {
    return (react_1.default.createElement(eui_1.EuiEmptyPrompt, { iconType: () => react_1.default.createElement(k9_icon_1.K9Icon, { className: 'no-message-k9-icon', filled: true }), iconColor: "default", title: (react_1.default.createElement("div", null,
            react_1.default.createElement(eui_1.EuiTitle, null,
                react_1.default.createElement("h2", { className: "margin-0" }, "K9 at your service!")),
            react_1.default.createElement(eui_1.EuiTitle, null,
                react_1.default.createElement("h2", { className: "margin-0" }, "How can I assist?")))), body: "I'm your AI assistant", titleSize: "s" }));
}
function messageToComment(message, options) {
    if (message.type === 'message') {
        return {
            username: message.user || '',
            type: 'regular',
            timestamp: (0, moment_1.default)(message.timestamp).format(options?.dateFormat || 'HH:mm'),
            timelineIcon: getTimelineIcon(message.user),
            children: (react_1.default.createElement("div", { style: { overflowWrap: 'break-word' } },
                message.user === types_1.User.K9 && options?.respondingToAttachment && (react_1.default.createElement(AttachmentBadge, { attachment: options.respondingToAttachment, error: message.errors?.attachment, disabled: options?.disableAttachment })),
                react_1.default.createElement(eui_1.EuiMarkdownFormat, { parsingPluginList: markdown_plugins_1.parsingPluginList, processingPluginList: markdown_plugins_1.processingPluginList }, message.content)))
        };
    }
    else {
        return {
            type: 'update',
            username: types_1.User.K9,
            event: getFunctionCallMessage(message.function.name)
        };
    }
}
function AttachmentBadge({ attachment, error, disabled }) {
    if (!attachment)
        return null;
    return (react_1.default.createElement("div", { style: { marginBottom: '10px' }, className: "attachment" },
        react_1.default.createElement("p", { style: { marginBottom: '2px' } }, error ? react_1.default.createElement(GraphTooLargeWarning, { error: error }) : 'Data retrieved from:'),
        react_1.default.createElement(eui_1.EuiToolTip, { content: disabled ? 'This graph no longer exists' : '' },
            react_1.default.createElement(eui_1.EuiBadge, { color: "hollow", href: chrome.addBasePath(`/app/investigate#/visualizer/${attachment.id}`), onClick: e => {
                    e.preventDefault(); // to prevent href from reloading the page
                    routeToPage(attachment.id);
                }, onClickAriaLabel: "Route to attachment page", isDisabled: disabled, "data-test-subj": `${attachment.title}-attachment` },
                "Graph '",
                attachment.title,
                "' ",
                react_1.default.createElement(eui_1.EuiIcon, { type: "graphApp", size: 's' })))));
}
function GraphTooLargeWarning({ error }) {
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(eui_1.EuiToolTip, { content: error },
            react_1.default.createElement(eui_1.EuiIcon, { type: "alert", color: "Warning", "data-test-subj": "large-graph-warning-icon" })),
        ' ',
        "Graph is too large"));
}
function getTimelineIcon(user) {
    return (react_1.default.createElement(eui_1.EuiAvatar, { size: "l", name: "", color: user === types_1.User.You ? '#0ABCF2' : '#861AFF', iconType: () => (user === types_1.User.You ?
            react_1.default.createElement("i", { style: { fontSize: '16px' }, className: "fa-solid fa-user" })
            : react_1.default.createElement(k9_icon_1.K9Icon, { className: 'chat-avatar-k9-icon', isWhite: true, filled: true })), style: { display: 'flex' } }));
}
function getFunctionCallMessage(functionName) {
    return {
        updateGraphItemsUiStyling: 'updated styles in the graph.',
        resetGraphItemsUiStyling: 'reset styles in the graph.',
    }[functionName] || `called ${functionName}`;
}
function routeToPage(id) {
    if (chrome.getApp().id === 'kibana') {
        visualizer_helper_1.VisualizerHelper.getInstance().switchToGraph(id);
    }
    else {
        const kbnUrl = (0, ng_injector_1.getNgService)('kbnUrl');
        kbnUrl.setWindowHref(chrome.addBasePath(`/app/investigate#/visualizer/${id}`, true));
    }
}
