"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageInput = MessageInput;
const React = __importStar(require("react"));
const react_1 = require("react");
const eui_1 = require("@elastic/eui");
const attachments_1 = require("../lib/attachments");
function MessageInput({ loading, onSubmit }) {
    const [query, setQuery] = (0, react_1.useState)('');
    const textAreaRef = (0, react_1.useRef)(null);
    async function sendMessage() {
        const attachment = await (0, attachments_1.getAttachment)();
        setQuery('');
        onSubmit(query.replaceAll(/\n/g, '  \n'), attachment); // Markdown needs two spaces after a newline to properly render it
    }
    (0, react_1.useEffect)(() => {
        if (textAreaRef.current) {
            // Used to vertically resize the input; can be removed with `field-sizing: content` after Mozilla bug 1832409
            textAreaRef.current.style.height = '0';
            textAreaRef.current.style.height = textAreaRef.current.scrollHeight + 'px';
        }
    }, [query]);
    return (React.createElement("div", { className: "message-input" },
        React.createElement(eui_1.EuiTextArea, { id: "message-input", maxLength: 50_000, inputRef: textAreaRef, fullWidth: true, value: query, onChange: e => setQuery(e.target.value), onKeyDown: e => {
                if (e.key === 'Enter' && !e.shiftKey) {
                    e.preventDefault(); // Prevent newline being entered
                    if (query.trim() && !loading) {
                        sendMessage();
                    }
                }
            }, placeholder: "Ask me anything", autoComplete: "off" }),
        React.createElement(eui_1.EuiButton, { fill: true, onClick: sendMessage, disabled: !query.trim() || loading }, "Send")));
}
