"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.executeToolCalls = executeToolCalls;
const notifier_1 = require("./notifier");
const graph_functions_1 = require("./graph_functions");
async function executeToolCalls(toolCalls) {
    const toolsExecutors = getToolExecutors();
    const errors = [];
    const toolCallResponses = [];
    await Promise.all(toolCalls.map(async (toolCall) => {
        try {
            const toolFunction = toolsExecutors[toolCall.function.name];
            if (!toolFunction) {
                throw new Error(`LLM tried to call unsupported function "${toolCall.function.name}"`);
            }
            const functionParams = JSON.parse(toolCall.function.arguments).params;
            const result = await toolFunction(functionParams);
            toolCallResponses.push({ callId: toolCall.callId, type: 'function_call_output', output: result || 'success' });
        }
        catch (e) {
            console.error(e);
            toolCallResponses.push({
                callId: toolCall.callId,
                type: 'function_call_output',
                output: `An error occurred calling this function: ${e.message}`
            });
            errors.push(`Error calling ${toolCall.function.name}: ${e.message}`);
        }
    }));
    if (errors.length) {
        notifier_1.notify.error('The LLM encountered errors while trying to apply changes:\n' + errors.join('\n'));
    }
    return toolCallResponses;
}
function getToolExecutors() {
    return {
        updateGraphItemsUiStyling: (0, graph_functions_1.getGraphFunction)('updateItemsUI') || couldNotFindGraphError,
        resetGraphItemsUiStyling: (0, graph_functions_1.getGraphFunction)('resetItemsUI') || couldNotFindGraphError
    };
}
function couldNotFindGraphError() {
    notifier_1.notify.warning('Could not find graph to update');
    return 'Error: Could not find graph to update.';
}
