"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAiClient = getAiClient;
const ollama_1 = __importDefault(require("./providers/ollama"));
const azure_openai_1 = __importDefault(require("./providers/azure_openai"));
const openai_1 = __importDefault(require("./providers/openai"));
const aws_bedrock_1 = __importDefault(require("./providers/aws_bedrock"));
function getAiClient(provider, config) {
    switch (provider) {
        case 'azure': return new azure_openai_1.default(config);
        case 'openai': return new openai_1.default(config);
        case 'ollama': return new ollama_1.default(config);
        case 'aws': return new aws_bedrock_1.default(config);
    }
}
