"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsBedrockConfigSchema = void 0;
const client_bedrock_runtime_1 = require("@aws-sdk/client-bedrock-runtime");
const credential_providers_1 = require("@aws-sdk/credential-providers");
const joi_1 = __importDefault(require("joi"));
const ai_client_1 = require("../ai_client");
class AwsBedrockClient extends ai_client_1.AiClient {
    client;
    parameters;
    constructor(config) {
        super();
        this.client = new client_bedrock_runtime_1.BedrockRuntimeClient({
            region: config.connection?.region,
            profile: config.connection?.profile,
            credentials: config.connection?.credentials || (0, credential_providers_1.fromNodeProviderChain)({ profile: config.connection?.profile })
        });
        this.parameters = config.parameters;
    }
    async sendMessagesToAi(inputs) {
        const messages = inputs.filter(ai_client_1.isMessageInput);
        const converseCommand = new client_bedrock_runtime_1.ConverseCommand({
            modelId: this.parameters.model,
            system: messages
                .filter(message => message.role === 'system')
                .map(message => ({ text: message.content })),
            messages: messages
                .filter(message => message.role !== 'system')
                .map(message => ({
                role: message.role,
                content: [{ text: message.content }]
            })),
            inferenceConfig: {
                temperature: this.parameters.temperature,
                topP: this.parameters.topP
            }
        });
        const response = await this.client.send(converseCommand);
        return [{ content: response.output?.message?.content?.[0]?.text }];
    }
}
exports.default = AwsBedrockClient;
exports.AwsBedrockConfigSchema = joi_1.default.object({
    connection: joi_1.default.object({
        region: joi_1.default.string(), // Can be provided using AWS_REGION or through profile
        profile: joi_1.default.string(), // Can also be set using AWS_PROFILE
        // If credentials not explicitly provided, we attempt to find credentials from the following sources listed here:
        // https://docs.aws.amazon.com/AWSJavaScriptSDK/v3/latest/Package/-aws-sdk-credential-providers/#fromnodeproviderchain
        credentials: joi_1.default.object({
            accessKeyId: joi_1.default.string().required(),
            secretAccessKey: joi_1.default.string().required(),
            sessionToken: joi_1.default.string(),
            credentialScope: joi_1.default.string(),
            accountId: joi_1.default.string(),
        })
    }),
    parameters: joi_1.default.object({
        model: joi_1.default.string().required(),
        temperature: joi_1.default.number(),
        topP: joi_1.default.number()
    }).required()
});
