"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OllamaConfigSchema = void 0;
const ollama_1 = require("ollama");
const joi_1 = __importDefault(require("joi"));
const ai_client_1 = require("../ai_client");
class OllamaClient extends ai_client_1.AiClient {
    client;
    parameters;
    constructor(config) {
        super();
        this.client = new ollama_1.Ollama({ host: config.connection?.host || 'http://localhost:11434' });
        this.parameters = config.parameters;
    }
    async sendMessagesToAi(inputs) {
        const response = await this.client.chat({
            model: this.parameters.model,
            messages: inputs.filter(ai_client_1.isMessageInput),
            options: {
                top_p: this.parameters?.topP,
                temperature: this.parameters?.temperature,
                num_ctx: this.parameters?.numCtx,
            }
        });
        return [{ content: response.message.content }];
    }
}
exports.default = OllamaClient;
exports.OllamaConfigSchema = joi_1.default.object({
    connection: joi_1.default.object({
        host: joi_1.default.string()
    }),
    parameters: joi_1.default.object({
        model: joi_1.default.string().required(),
        temperature: joi_1.default.number().min(0).max(1),
        topP: joi_1.default.number().min(0).max(1),
        numCtx: joi_1.default.number().integer().min(1),
    }).required()
});
