"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resetGraphItemsUiStyling = void 0;
/**
 * Resets the UI styling of nodes and edges in a graph.
 * @example graphBrowserVis.resetItemsUI(updateItems)
 * @see https://docs.siren.io/siren-platform-user-guide/14.7/scripting/v1/visualization_apis.html#_graphbrowservis_resetitemsuiresetitems_promise_void
 */
exports.resetGraphItemsUiStyling = {
    type: 'function',
    name: 'resetGraphItemsUiStyling',
    description: 'Resets the UI style options of nodes or edges on the UI graph. Should only be called if graph data has been provided.',
    strict: false,
    parameters: {
        type: 'object',
        properties: {
            params: {
                type: 'array',
                description: 'The list of items on the graph to reset styles for',
                items: {
                    type: 'object',
                    required: ['id', 'type', 'properties'],
                    properties: {
                        type: {
                            type: 'string',
                            description: 'The type of the item on the graph that has to be reset',
                            enum: ['node', 'edge']
                        },
                        id: {
                            type: 'string',
                            description: 'The ID of the item that has to be reset'
                        },
                        properties: {
                            type: 'array',
                            minItems: 1,
                            items: {
                                type: 'string',
                                description: 'The properties of the item that should be reset. Properties not listed will not be reset.',
                                enum: [
                                    'color',
                                    'colorOpacity',
                                    'iconColor',
                                    'iconColorOpacity',
                                    'size',
                                    'label',
                                    'fontIcon',
                                    'fontStyle',
                                    'badges',
                                    'autoRotate',
                                    'arrow',
                                    'width',
                                    'style',
                                    'borderColor',
                                    'borderOpacity'
                                ]
                            }
                        }
                    }
                }
            }
        }
    }
};
