"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateGraphItemsUiStyling = void 0;
/**
 * Updates the UI styling of nodes and edges in a graph.
 * @example graphBrowserVis.updateItemsUI(updateItems)
 * @see https://docs.siren.io/siren-platform-user-guide/14.6/scripting/v1/visualization_apis.html#_graphbrowservis_updateitemsuiupdateitems_promise_void
 */
exports.updateGraphItemsUiStyling = {
    type: 'function',
    name: 'updateGraphItemsUiStyling',
    description: `
    Set the UI style options of nodes or edges on the UI graph. Should only be called if graph data has been provided. Note that the
    canvas that the nodes are on are white, so choosing white as a colour for certain things will make it invisible.
  `,
    strict: false,
    parameters: {
        type: 'object',
        properties: {
            params: {
                type: 'array',
                items: {
                    type: 'object',
                    required: ['type', 'id', 'cfg'],
                    properties: {
                        type: {
                            type: 'string',
                            description: 'The type of the item on the graph that has to be updated',
                            enum: ['node', 'edge'],
                        },
                        id: {
                            type: 'string',
                            description: 'The ID of the item that has to be updated'
                        },
                        cfg: {
                            type: 'object',
                            minProperties: 1,
                            description: 'The style configuration for the item. Properties not included in this configuration will not be updated (i.e. the items will maintain the same style)',
                            properties: {
                                color: { type: 'string', description: 'New color for the item as a hex code. Default is #ffffff for nodes and #0099ff for edges.' },
                                colorOpacity: { type: 'number', description: 'New color opacity for the item. Default is 0 for nodes and 1 for edges.', minimum: 0, maximum: 1 },
                                borderColor: { type: 'string', description: 'New border color for the item. Only applicable to nodes. Default is #ffffff for nodes and #0099ff for edges.' },
                                borderOpacity: { type: 'number', description: 'New border opacity for the item. Only applicable to nodes. Default is 0.', minimum: 0, maximum: 1 },
                                size: {
                                    type: 'number',
                                    description: 'New size for the node. Default is 1. Only applicable to nodes. Size increases logarithmically (difference between 1 and 2 is bigger than between 9 and 10). Large sizes (greater than 5) will make it difficult for the user to see other nodes, so try to avoid these large node sizes if possible. When highlighting nodes, using a value between 1 and 2 is recommended.',
                                    minimum: 0.1,
                                    maximum: 10
                                },
                                fontIcon: { type: 'string', description: 'New font icon for the item using FontAwesome syntax. Only applicable to nodes.' },
                                iconColor: { type: 'string', description: 'New icon color for the item. Only applicable to nodes.' },
                                iconColorOpacity: { type: 'number', description: 'New icon color opacity for the item. Default is 1. Only applicable to nodes', minimum: 0, maximum: 1 },
                                imageUrl: { type: 'string', description: 'New image icon for the item. Only applicable to nodes.' },
                                label: { type: 'string', description: 'New label for the item' },
                                fontStyle: {
                                    type: 'object',
                                    properties: {
                                        color: { type: 'string', description: 'New hex color for the label. Default is #000000.' },
                                        highlight: { type: 'string', description: 'New hex color for the label background. Default is #ffffff00' },
                                        bold: { type: 'boolean', description: 'When true, displays the label as bold. Default is false.' },
                                        italic: { type: 'boolean', description: 'When true, displays the label as italic. Default is false.' },
                                        size: {
                                            type: 'number',
                                            description: 'Number between 0-10 to set min or max size respectively. Default is 2.',
                                            minimum: 0,
                                            maximum: 10
                                        },
                                    }
                                },
                                badges: {
                                    type: 'array',
                                    description: 'Badges to be displayed along the border of the node. Only applicable to nodes.',
                                    items: {
                                        type: 'object',
                                        properties: {
                                            pos: {
                                                type: 'string',
                                                description: 'Position of the badge on the circumference of the round node. They represent the four cardinal points of a compass: nw = north west = top left; sw = south west = bottom left; se = south east = bottom right;',
                                                enum: ['nw', 'sw', 'se'] // `ne` not included because it is overridden by relation count
                                            },
                                            text: {
                                                type: 'string',
                                                description: 'Text content for the badge.',
                                                maxLength: 5
                                            },
                                            fontIcon: { type: 'string', description: 'Font icon content for the badge using FontAwesome syntax' },
                                            color: { type: 'string', description: 'Color for the badge (note that the text colour is white)' }
                                        }
                                    }
                                },
                                autoRotate: { type: 'string', description: 'When false, the label stays horizontal rather than matching the orientation of the edge. Default is true. Only applicable to edges.' },
                                arrow: {
                                    type: 'object',
                                    description: 'Arrow configuration. Only applicable to edges.',
                                    properties: {
                                        direction: {
                                            type: 'string',
                                            description: 'Where to place an arrow head on the edge.',
                                            enum: ['left', 'right', 'both', 'none']
                                        },
                                    }
                                },
                                width: { type: 'number', description: 'Width of the edge. Default width is 1. Only applicable to edges.', minimum: 1, maximum: 10 },
                                style: { type: 'string', description: 'Style of the edge line. Default is `solid`. Only applicable to edges.', enum: ['solid', 'dashed', 'dotted'] },
                            }
                        }
                    }
                }
            }
        }
    }
};
