"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getGenerateReportRoute = getGenerateReportRoute;
const dedent_1 = __importDefault(require("dedent"));
// @ts-ignore
const audited_route_handler_1 = require("../../../../src/siren_core_plugins/siren_audit/server/audited_route_handler");
// @ts-ignore
const constants_1 = require("../../../../src/siren_core_plugins/siren_audit/common/constants");
const register_ui_contexts_1 = require("../setup/register_ui_contexts");
const ai_client_1 = require("../ai_client");
const get_advanced_settings_1 = require("../setup/get_advanced_settings");
const report_system_message_1 = require("./prompts/report_system_message");
const route_utils_1 = require("./route_utils");
function getGenerateReportRoute(server) {
    const provider = server.config().get('siren-ai.provider');
    const config = server.config().get(`siren-ai.providerConfig.${provider}`);
    const ai = (0, ai_client_1.getAiClient)(provider, config);
    const { mockLlmResponses } = (0, route_utils_1.getDevConfig)(server);
    return {
        path: '/api/ai/generateReport',
        method: 'POST',
        options: {
            pre: [{ method: (0, route_utils_1.isRequestAllowed)(register_ui_contexts_1.SirenAiContexts.LLM_ACCESES_PERMISSION) }]
        },
        handler: (0, audited_route_handler_1.auditedRouteHandler)(constants_1.LOGGED_TYPES.LLMPrompt, async function (req) {
            if (mockLlmResponses) {
                return { content: '# Hello\n\nI am a mocked response.\n\nYou look wonderful today!' };
            }
            const selectedNodes = req.payload.selection;
            const customPrompt = req.payload.customPrompt;
            const systemMessages = [await (0, report_system_message_1.getReportSystemMessage)()];
            const userSystemPrompt = customPrompt || await req.getUiSettingsService().get(req, get_advanced_settings_1.AdvancedSettings.GRAPH_REPORT_PROMPT);
            if (userSystemPrompt) {
                systemMessages.push({ type: 'message', role: 'system', content: userSystemPrompt });
            }
            let message = `${req.payload.graph}`;
            if (selectedNodes?.length) {
                const nodesList = selectedNodes.map(nodeName => `"${nodeName}"`).join(', ');
                message += (0, dedent_1.default) `\n
            # Selected nodes
  
            These nodes are selected in the graph and should be the focus for the report important: ${nodesList}
          `;
            }
            const messages = [
                ...systemMessages,
                { type: 'message', role: 'user', content: message }
            ];
            const response = await (0, route_utils_1.sendMessagesToAiBoomifyErrors)(ai, messages, { disableTools: true });
            return response[0];
        })
    };
}
