"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isRequestAllowed = isRequestAllowed;
exports.sendMessagesToAiBoomifyErrors = sendMessagesToAiBoomifyErrors;
exports.getDevConfig = getDevConfig;
const boom_1 = require("@hapi/boom");
function isRequestAllowed(contextId) {
    return async (request) => {
        const credentials = request.auth.credentials;
        const accessControlPlugin = request.server.plugins.investigate_access_control;
        if (accessControlPlugin) {
            const isAllowed = await accessControlPlugin.isAllowed(credentials, null, ['view'], contextId);
            if (!isAllowed) {
                throw (0, boom_1.forbidden)('You do not have permission to generate a report.');
            }
        }
        return null;
    };
}
async function sendMessagesToAiBoomifyErrors(ai, inputs, options) {
    try {
        return await ai.sendMessagesToAi(inputs, options);
    }
    catch (e) {
        console.error(e);
        const errorMessage = 'An error occurred while generating a response. Try reducing the amount of data being sent.';
        throw new boom_1.Boom(errorMessage, { statusCode: e.status || 500 });
    }
}
function getDevConfig(server) {
    const devConfig = server.config().get('siren-ai._dev');
    return {
        mockLlmResponses: false,
        ...(devConfig || {}),
    };
}
