"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdvancedSettings = void 0;
exports.getAdvancedSettings = getAdvancedSettings;
var AdvancedSettings;
(function (AdvancedSettings) {
    AdvancedSettings["K9_CHAT_PROMPT"] = "siren-ai:k9_chat_prompt";
    AdvancedSettings["GRAPH_REPORT_PROMPT"] = "siren-ai:graph_report_prompt";
})(AdvancedSettings || (exports.AdvancedSettings = AdvancedSettings = {}));
function getAdvancedSettings() {
    return {
        [AdvancedSettings.K9_CHAT_PROMPT]: {
            title: 'Siren AI: K9 Chat Prompt',
            value: '',
            type: 'markdown',
            description: `A custom prompt for the K9 chat interface.
          This will be used when generating responses in the K9 chat. This input supports markdown syntax highlighting.`,
        },
        [AdvancedSettings.GRAPH_REPORT_PROMPT]: {
            title: 'Siren AI: Graph Report Prompt',
            type: 'markdown',
            value: getDefaultGraphReportPrompt(),
            description: `A custom prompt for generating reports on graph data.
          This will be used when generating reports from the graph browser. This input supports markdown syntax highlighting.`,
        }
    };
}
function getDefaultGraphReportPrompt() {
    return `Here are the following sections to include in the graph report:

## Graph Nodes
List the specific nodes or elements in the graph that are the focus of the report.
If nodes are selected, provide context about why these nodes were selected.

## General Information
Include details about the entire graph or dataset:
Description: Briefly describe the graph and its components.
Data Source: Mention where the data for the graph is sourced from.
Key Metrics: Highlight important metrics or values relevant to the graph.

## Detailed Analysis
Break down the nodes individually. For each node, include:
Description: Provide detailed information about the node.
Metrics/Attributes: List and explain the relevant metrics or attributes associated with the node.
Trends: Analyze any trends or patterns observed in the data for this node.
Comparisons: Compare the node's performance or characteristics with others if applicable.

## Conclusions
Summarize the findings from the detailed analysis. Highlight any significant insights or observations.

## Recommendations
Provide actionable recommendations based on the conclusions.
These could include suggestions for improvement, strategies for optimization, or any necessary actions.`;
}
