/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.api.stores;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.data.Content;
import io.annot8.api.filters.Filter;
import io.annot8.api.helpers.WithFilter;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface AnnotationStore
extends WithFilter<Annotation> {
    public Content<?> getContent();

    public Annotation.Builder getBuilder();

    default public Annotation.Builder create() {
        return this.getBuilder();
    }

    default public Annotation.Builder copy(Annotation existing) {
        return (Annotation.Builder)((Annotation.Builder)this.getBuilder().from(existing)).newId();
    }

    default public Annotation.Builder edit(Annotation existing) {
        return (Annotation.Builder)this.getBuilder().from(existing);
    }

    public void delete(Annotation var1);

    default public void delete(Collection<Annotation> annotations) {
        annotations.forEach(this::delete);
    }

    default public void deleteAll() {
        this.delete(this.getAll().collect(Collectors.toList()));
    }

    public Stream<Annotation> getAll();

    default public Stream<Annotation> getByType(String type) {
        return this.getAll().filter((? super T a) -> type.equals(a.getType()));
    }

    default public <B extends Bounds> Stream<Annotation> getByBounds(Class<B> boundsClass) {
        return this.getAll().filter((? super T a) -> a.getBounds() != null && boundsClass.isInstance(a.getBounds()));
    }

    default public <B extends Bounds> Stream<Annotation> getByBoundsAndType(Class<B> boundsClass, String type) {
        return this.getByBounds(boundsClass).filter((? super T a) -> type.equals(a.getType()));
    }

    public Optional<Annotation> getById(String var1);

    @Override
    default public Stream<Annotation> filter(Filter<Annotation> filter) {
        return this.getAll().filter(filter::test);
    }
}

