/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.components;

import io.annot8.api.components.Annot8Component;
import io.annot8.api.context.Context;
import io.annot8.common.components.logging.Logging;
import io.annot8.common.components.metering.Metering;
import io.annot8.common.components.metering.Metrics;
import io.annot8.common.components.metering.NoOpMetrics;
import io.micrometer.core.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponent
implements Annot8Component {
    private Logger logger;
    private Metrics metrics;

    public AbstractComponent() {
        this(null, null);
    }

    public AbstractComponent(Context context) {
        this(context.getResource(Logging.class).orElse(null), context.getResource(Metering.class).orElse(null));
    }

    public AbstractComponent(Logging logging, Metering metering) {
        this.logger = logging != null ? logging.getLogger(this.getClass()) : null;
        this.metrics = metering != null ? metering.getMetrics(this.getClass()) : null;
    }

    protected Logger log() {
        if (this.logger == null) {
            this.createDefaultLogger();
        }
        return this.logger;
    }

    protected Metrics metrics() {
        if (this.metrics == null) {
            this.createDefaultMetrics();
        }
        return this.metrics;
    }

    public void setLogger(@Nullable Logger logger) {
        this.logger = logger;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    protected void createDefaultLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    protected void createDefaultMetrics() {
        this.metrics = NoOpMetrics.instance();
    }
}

