/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.data.bounds;

import io.annot8.api.data.Content;
import io.annot8.common.data.bounds.AbstractCellBounds;
import io.annot8.common.data.bounds.MultiCellData;
import io.annot8.common.data.content.Row;
import io.annot8.common.data.content.Table;
import io.annot8.common.data.content.TableContent;
import java.util.HashMap;
import java.util.Optional;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

public class MultiCellBounds
extends AbstractCellBounds {
    private final int[] cells;
    private final int row;

    @JsonbCreator
    public MultiCellBounds(@JsonbProperty(value="row") int row, @JsonbProperty(value="cells") int[] cells) {
        this.row = row;
        this.cells = cells;
    }

    public int getRow() {
        return this.row;
    }

    public int[] getCells() {
        return this.cells;
    }

    @Override
    public <D, C extends Content<D>, R> Optional<R> getData(C content, Class<R> requiredClass) {
        if (requiredClass.equals(MultiCellData.class)) {
            if (!this.isValid(content)) {
                return Optional.empty();
            }
            TableContent tableContent = (TableContent)content;
            Optional<Row> rowOptional = ((Table)tableContent.getData()).getRow(this.row);
            if (rowOptional.isPresent()) {
                Row r = rowOptional.get();
                HashMap<Integer, Object> values = new HashMap<Integer, Object>();
                HashMap<String, Integer> headers = new HashMap<String, Integer>();
                for (int i : this.cells) {
                    Optional<Object> valueOptional = r.getValueAt(i);
                    Optional<String> headerOptional = r.getColumnName(i);
                    if (!valueOptional.isPresent()) continue;
                    values.put(i, valueOptional.get());
                    headerOptional.ifPresent(s -> headers.put((String)s, i));
                }
                MultiCellData multiCellData = new MultiCellData(values, headers);
                return Optional.of(requiredClass.cast(multiCellData));
            }
        }
        return Optional.empty();
    }

    @Override
    public <D, C extends Content<D>> boolean isValid(C content) {
        if (!super.isValid(content)) {
            return false;
        }
        for (int i : this.cells) {
            if (this.isCellReferenceValid((TableContent)content, this.row, i)) continue;
            return false;
        }
        return true;
    }
}

