/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.data.bounds;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class MultiCellData {
    private final Map<Integer, Object> data;
    private final Map<String, Integer> columnNames;

    public MultiCellData(Map<Integer, Object> data, Map<String, Integer> columnNames) {
        this.data = data;
        this.columnNames = columnNames;
    }

    public Collection<Integer> getColumns() {
        return this.data.keySet();
    }

    public Map<String, Integer> getColumnNames() {
        return this.columnNames;
    }

    public Map<Integer, Object> getData() {
        return this.data;
    }

    public <T> Optional<T> getDataForColumn(String columnName, Class<T> requiredClass) {
        if (this.getColumnNames().containsKey(columnName)) {
            return this.getDataForColumn(this.getColumnNames().get(columnName), requiredClass);
        }
        return Optional.empty();
    }

    public <T> Optional<T> getDataForColumn(int column, Class<T> requiredClass) {
        Object value;
        if (this.data.containsKey(column) && requiredClass.isAssignableFrom((value = this.data.get(column)).getClass())) {
            return Optional.of(requiredClass.cast(value));
        }
        return Optional.empty();
    }
}

