/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.processing.indices;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.annot8.api.annotations.Annotation;
import io.annot8.common.data.bounds.SpanBounds;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpanIndices {
    private final List<Annotation> over;
    private final List<Annotation> under;

    public SpanIndices(Stream<Annotation> overStream, Stream<Annotation> underStream) {
        this.over = this.filterSpanBounds(overStream);
        this.under = this.filterSpanBounds(underStream);
    }

    public Multimap<Annotation, Annotation> topDown() {
        Map<Annotation, SpanBounds> underMap = this.under.stream().collect(Collectors.toMap(Function.identity(), e -> e.getBounds(SpanBounds.class).orElse(null)));
        HashMultimap<Annotation, Annotation> multimap = HashMultimap.create();
        for (Annotation o : this.over) {
            List<Annotation> found;
            Optional<SpanBounds> oBounds = o.getBounds(SpanBounds.class);
            if (!oBounds.isPresent() || (found = this.findEnclosedAnnotations(oBounds.get(), underMap)).isEmpty()) continue;
            multimap.putAll((Object)o, found);
        }
        return multimap;
    }

    private List<Annotation> filterSpanBounds(Stream<Annotation> stream) {
        return stream.filter(s -> s.getBounds(SpanBounds.class).isPresent()).collect(Collectors.toList());
    }

    private List<Annotation> findEnclosedAnnotations(SpanBounds bounds, Map<Annotation, SpanBounds> list) {
        return list.entrySet().stream().filter(e -> bounds.isWithin((SpanBounds)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Multimap<Annotation, Annotation> bottomUp() {
        Map<Annotation, SpanBounds> overMap = this.over.stream().collect(Collectors.toMap(e -> e, e -> e.getBounds(SpanBounds.class).orElse(null)));
        HashMultimap<Annotation, Annotation> multimap = HashMultimap.create();
        for (Annotation u : this.under) {
            List<Annotation> found;
            Optional<SpanBounds> oBounds = u.getBounds(SpanBounds.class);
            if (!oBounds.isPresent() || (found = this.findInsideAnnotations(oBounds.get(), overMap)).isEmpty()) continue;
            multimap.putAll((Object)u, found);
        }
        return multimap;
    }

    private List<Annotation> findInsideAnnotations(SpanBounds bounds, Map<Annotation, SpanBounds> list) {
        return list.entrySet().stream().filter(e -> ((SpanBounds)e.getValue()).isWithin(bounds)).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

