/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.utils.java;

import java.util.Optional;
import java.util.function.Function;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    public static Optional<Integer> toInt(Optional<Object> valueOptional) {
        return ConversionUtils.convertOptional(valueOptional, ConversionUtils::toInt);
    }

    public static Optional<Long> toLong(Optional<Object> valueOptional) {
        return ConversionUtils.convertOptional(valueOptional, ConversionUtils::toLong);
    }

    public static Optional<Double> toDouble(Optional<Object> valueOptional) {
        return ConversionUtils.convertOptional(valueOptional, ConversionUtils::toDouble);
    }

    private static <T> Optional<T> convertOptional(Optional<Object> valueOptional, Function<Object, T> function) {
        if (valueOptional.isPresent()) {
            return valueOptional.map(function);
        }
        return Optional.empty();
    }

    private static Double toDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private static Long toLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private static Integer toInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

