/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.cyber.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractRegexProcessor;
import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="Epoch Time")
@ComponentDescription(value="Extract epoch time in either seconds or milliseconds, with optional start and end dates")
@ComponentTags(value={"cyber", "time", "text"})
@SettingsClass(value=Settings.class)
public class EpochTime
extends AbstractProcessorDescriptor<Processor, Settings> {
    @Override
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    @Override
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/temporal/instant", SpanBounds.class).build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private Instant earliestTimestamp = Instant.MIN;
        private Instant latestTimestamp = Instant.MAX;
        private boolean milliseconds = false;

        @Override
        public boolean validate() {
            return this.earliestTimestamp.isBefore(this.latestTimestamp) || this.earliestTimestamp.equals(this.latestTimestamp);
        }

        @Description(value="The earliest timestamp to accept - timestamps before this will be ignored")
        public Instant getEarliestTimestamp() {
            return this.earliestTimestamp;
        }

        public void setEarliestTimestamp(Instant earliestTimestamp) {
            this.earliestTimestamp = earliestTimestamp;
        }

        @Description(value="The latest timestamp to accept - timestamps after this will be ignored")
        public Instant getLatestTimestamp() {
            return this.latestTimestamp;
        }

        public void setLatestTimestamp(Instant latestTimestamp) {
            this.latestTimestamp = latestTimestamp;
        }

        @Description(value="Whether timestamps are in milliseconds (true) or seconds (false)")
        public boolean isMilliseconds() {
            return this.milliseconds;
        }

        public void setMilliseconds(boolean milliseconds) {
            this.milliseconds = milliseconds;
        }
    }

    public static class Processor
    extends AbstractRegexProcessor {
        private Settings settings;

        public Processor(Settings settings) {
            super(Pattern.compile("\\b\\d+\\b", 2), 0, "entity/temporal/instant");
            this.settings = settings;
        }

        @Override
        protected boolean acceptMatch(Matcher m) {
            long l;
            try {
                l = Long.parseLong(m.group());
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            Instant i = this.settings.isMilliseconds() ? Instant.ofEpochMilli(l) : Instant.ofEpochSecond(l);
            return !(!i.isAfter(this.settings.getEarliestTimestamp()) && !i.equals(this.settings.getEarliestTimestamp()) || !i.isBefore(this.settings.getLatestTimestamp()) && !i.equals(this.settings.getLatestTimestamp()));
        }

        @Override
        protected void addProperties(Annotation.Builder builder, Matcher m) {
            Instant i;
            long l;
            try {
                l = Long.parseLong(m.group());
            }
            catch (NumberFormatException nfe) {
                return;
            }
            if (this.settings.isMilliseconds()) {
                i = Instant.ofEpochMilli(l);
                builder.withProperty("unit", "ms");
            } else {
                i = Instant.ofEpochSecond(l);
                builder.withProperty("unit", "s");
            }
            builder.withProperty("value", i);
        }
    }
}

