/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.cyber.processors;

import com.google.common.net.InetAddresses;
import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractRegexProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="IPv6")
@ComponentDescription(value="Extract IPv6 addresses")
@ComponentTags(value={"cyber", "communications", "ip", "text"})
public class IPv6
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    @Override
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    @Override
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/ipaddress", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractRegexProcessor {
        public Processor() {
            super(Pattern.compile("([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|(([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3})"), 0, "entity/ipaddress");
        }

        @Override
        protected boolean acceptMatch(Matcher m) {
            return InetAddresses.isInetAddress(m.group());
        }

        @Override
        protected void addProperties(Annotation.Builder builder, Matcher m) {
            builder.withProperty("version", 6);
        }
    }
}

