/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.financial.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.api.stores.AnnotationStore;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Base58;

@ComponentName(value="Bitcoin Address")
@ComponentDescription(value="Extract valid Bitcoin addresses from text")
public class BitcoinAddress
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    @Override
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    @Override
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/financialAccount", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        public static final Pattern BITCOIN_PATTERN = Pattern.compile("\\b([13][a-zA-Z0-9]{25,34})|(bc1)[a-zA-Z0-9]{23,32}\\b");

        @Override
        protected void process(Text content) {
            Matcher m = BITCOIN_PATTERN.matcher((CharSequence)content.getData());
            AnnotationStore annotationStore = content.getAnnotations();
            while (m.find()) {
                String value = m.group();
                try {
                    Base58.decodeChecked((String)value);
                }
                catch (AddressFormatException afe) {
                    continue;
                }
                String accountType = value.startsWith("1") ? "bitcoin#P2PKH" : (value.startsWith("3") ? "bitcoin#P2SH" : (value.startsWith("bc1") ? "bitcoin#Bech32" : "bitcoin"));
                ((Annotation.Builder)((Annotation.Builder)annotationStore.create().withType("entity/financialAccount")).withBounds(new SpanBounds(m.start(), m.end())).withProperty("accountType", accountType)).save();
            }
        }
    }
}

