/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.gazetteers.processors;

import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.components.gazetteers.processors.AhoCorasick;
import io.annot8.components.gazetteers.processors.impl.TaxonomyGazetteer;
import io.annot8.utils.text.PluralUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.AllDirectedPaths;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;
import uk.gov.nca.annot8.components.opennlp.service.OpenNlpService;

@ComponentName(value="Taxonomy")
@ComponentDescription(value="Extract given terms from text and annotate with taxonomy")
@SettingsClass(value=Settings.class)
public class Taxonomy
extends AhoCorasick<Settings> {
    private OpenNlpService openNlpService;

    @Override
    protected AhoCorasick.Processor createComponent(Context context, Settings settings) {
        TaxonomyInstance tax;
        if (this.openNlpService.hasTaxonomy(settings.getIndex())) {
            tax = this.openNlpService.getTaxonomy(settings.getIndex());
        } else {
            tax = new TaxonomyInstance(settings.getIndex(), settings.getIdField(), settings.getPreferredTermField(), new HashSet<String>(settings.getSynonymFields()), settings.getParentsField());
            this.openNlpService.addTaxonomy(settings.getIndex(), tax);
        }
        return new AhoCorasick.Processor(new TaxonomyGazetteer(tax.getSearchTaxonomy(settings.isPlurals(), settings.isCaseSensitive()), tax.getSynAliases(settings.isPlurals(), settings.isCaseSensitive()), tax.getSynAdditionalData(settings.isPlurals(), settings.isCaseSensitive()), tax.getAllSynonyms()), settings);
    }

    public void setOpenNlpService(OpenNlpService openNlpService) {
        this.openNlpService = openNlpService;
    }

    public static class Settings
    extends AhoCorasick.Settings {
        private Map<Set<String>, Map<String, Object>> taxonomy = Collections.emptyMap();
        private Set<String> searchTerms = new HashSet<String>();
        boolean taxonomyHasBeenSet = false;
        boolean pluralsHasBeenSet = false;
        boolean caseSensitiveHasBeenSet = false;
        private String index;
        private String idField;
        private String preferredTermField;
        private List<String> synonymFields;
        private String parentsField;
        private final Map<String, Set<String>> synAliases = new HashMap<String, Set<String>>();
        private final Map<String, Map<String, Object>> synAdditionalData = new HashMap<String, Map<String, Object>>();

        private void setAliases() {
            this.taxonomy.forEach((syns, additionalData) -> syns.forEach(syn1 -> syns.forEach(syn2 -> ((Set)this.synAliases.getOrDefault(syn1, new HashSet())).add(syn2))));
        }

        private void setAdditionalData() {
            this.taxonomy.forEach((syns, additionalData) -> syns.forEach(syn -> {
                Map thisAdditionalData = this.synAdditionalData.getOrDefault(syn, new HashMap());
                ArrayList ids = thisAdditionalData.getOrDefault("ids", new ArrayList());
                ArrayList<Map> nodes = thisAdditionalData.getOrDefault("nodes", new ArrayList());
                ids.add(additionalData.get("id"));
                nodes.add((Map)additionalData);
                this.synAdditionalData.put((String)syn, thisAdditionalData);
                thisAdditionalData.put("ids", ids);
                thisAdditionalData.put("nodes", nodes);
            }));
        }

        public Map<String, Set<String>> getSynAliases() {
            return this.synAliases;
        }

        public Set<String> getSearchTerms() {
            return this.searchTerms;
        }

        public Map<String, Map<String, Object>> getSynAdditionalData() {
            return this.synAdditionalData;
        }

        public Map<Set<String>, Map<String, Object>> getTaxonomy() {
            return this.taxonomy;
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public String getIdField() {
            return this.idField;
        }

        public void setIdField(String idField) {
            this.idField = idField;
        }

        public String getPreferredTermField() {
            return this.preferredTermField;
        }

        public void setPreferredTermField(String preferredTermField) {
            this.preferredTermField = preferredTermField;
        }

        public List<String> getSynonymFields() {
            return this.synonymFields;
        }

        public void setSynonymFields(List<String> synonymFields) {
            this.synonymFields = synonymFields;
        }

        public String getParentsField() {
            return this.parentsField;
        }

        public void setParentsField(String parentsField) {
            this.parentsField = parentsField;
        }

        public void setTaxonomy(List<Map<String, Object>> inputTaxonomy) {
            HashMap<Set<String>, Map<String, Object>> termsAndData = new HashMap<Set<String>, Map<String, Object>>();
            inputTaxonomy.forEach(i -> {
                List synonyms = (List)i.get("synonyms");
                HashSet synSet = new HashSet(synonyms);
                termsAndData.put(synSet, (Map<String, Object>)i);
                this.searchTerms.addAll(synSet);
            });
            this.taxonomy = termsAndData;
            this.taxonomyHasBeenSet = true;
            if (this.caseSensitiveHasBeenSet && this.pluralsHasBeenSet) {
                this.resetTaxonomy();
                this.setAliases();
                this.setAdditionalData();
            }
        }

        @Override
        public void setPlurals(boolean plurals) {
            super.setPlurals(plurals);
            this.pluralsHasBeenSet = true;
            if (this.taxonomyHasBeenSet && this.caseSensitiveHasBeenSet) {
                this.resetTaxonomy();
                this.setAliases();
                this.setAdditionalData();
            }
        }

        @Override
        public void setCaseSensitive(boolean caseSensitive) {
            super.setCaseSensitive(caseSensitive);
            this.caseSensitiveHasBeenSet = true;
            if (this.taxonomyHasBeenSet && this.pluralsHasBeenSet) {
                this.resetTaxonomy();
                this.setAliases();
                this.setAdditionalData();
            }
        }

        public void resetTaxonomy() {
            HashMap<Set<String>, Map<String, Object>> newTaxonomy = new HashMap<Set<String>, Map<String, Object>>();
            this.taxonomy.forEach((synonyms, v) -> {
                HashSet synSet = new HashSet(synonyms);
                synonyms.forEach(j -> {
                    String pluralS = null;
                    if (this.isPlurals()) {
                        pluralS = PluralUtils.pluralise(j);
                        synSet.add(pluralS);
                    }
                    if (!this.isCaseSensitive()) {
                        synSet.add(j.toLowerCase());
                        if (pluralS != null) {
                            synSet.add(pluralS.toLowerCase());
                        }
                    }
                });
                newTaxonomy.put(synSet, (Map<String, Object>)v);
            });
            this.taxonomy = newTaxonomy;
        }

        @Override
        public boolean validate() {
            return super.validate() && this.taxonomy != null;
        }
    }

    public class TaxonomyInstance {
        private String name;
        private List<TaxonomyNode> nodes;
        private Map<String, TaxonomyNode> idNodes;
        private Map<String, Set<TaxonomyNode>> synNodes;
        private Set<String> allSynonyms;
        private Map<SearchType, Map<String, Object>> searchData;
        private HashMap<Set<String>, Map<String, Object>> searchTaxonomy;
        private Map<String, Set<String>> synAliases;
        private Map<String, Map<String, Object>> synAdditionalData;
        private DirectedAcyclicGraph<String, DefaultEdge> graph;
        private String idField;
        private String ptField;
        private Set<String> synonymFields;
        private String parentsField;
        private Set<String> allIndexFields;

        public TaxonomyInstance(String name) {
            this.setName(name);
            this.nodes = new ArrayList<TaxonomyNode>();
            this.synNodes = new HashMap<String, Set<TaxonomyNode>>();
            this.graph = new DirectedAcyclicGraph(DefaultEdge.class);
            this.allSynonyms = new HashSet<String>();
            this.idNodes = new HashMap<String, TaxonomyNode>();
            this.searchData = new HashMap<SearchType, Map<String, Object>>();
        }

        public TaxonomyInstance(String name, String idField, String ptField, Set<String> synonymFields, String parentsField) {
            this(name);
            this.idField = idField;
            this.ptField = ptField;
            this.synonymFields = synonymFields;
            this.parentsField = parentsField;
            this.allIndexFields = new HashSet<String>(Arrays.asList(idField, ptField, ptField, parentsField));
            this.allIndexFields.addAll(synonymFields);
            this.buildFromIndex();
            this.updateNodes();
            this.setSearchObjects();
        }

        public TaxonomyNode getNodeFromSearchHit(SearchHit hit) {
            Map hitMap = hit.getSourceAsMap();
            String id = (String)hitMap.get(this.idField);
            String pt = (String)hitMap.get(this.ptField);
            HashSet<String> parents = new HashSet<String>((List)hitMap.get(this.parentsField));
            HashSet<String> synonyms = new HashSet<String>();
            this.synonymFields.forEach(synfield -> synonyms.addAll((List)hitMap.get(synfield)));
            return new TaxonomyNode(id, pt, synonyms, parents);
        }

        public void buildFromIndex() {
            String[] includeFields = this.allIndexFields.toArray(new String[0]);
            String[] excludeFields = new String[]{};
            SearchRequest sr = new SearchRequest(new String[]{this.name}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).fetchSource(includeFields, excludeFields).size(1000)).scroll(TimeValue.timeValueMinutes((long)1L));
            SearchResponse searchResponse = (SearchResponse)Taxonomy.this.openNlpService.getPlugin().getClient().search(sr).actionGet();
            String scrollId = searchResponse.getScrollId();
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                this.addNode(this.getNodeFromSearchHit(hit));
            }
            while (hits.getHits().length > 0) {
                SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
                scrollRequest.scroll(TimeValue.timeValueSeconds((long)30L));
                SearchResponse searchScrollResponse = (SearchResponse)Taxonomy.this.openNlpService.getPlugin().getClient().searchScroll(scrollRequest).actionGet();
                scrollId = searchScrollResponse.getScrollId();
                hits = searchScrollResponse.getHits();
                for (SearchHit hit : hits) {
                    this.addNode(this.getNodeFromSearchHit(hit));
                }
            }
        }

        public void addNode(TaxonomyNode node) {
            this.nodes.add(node);
            this.idNodes.put(node.getId(), node);
            for (String syn : node.getSynonyms()) {
                ((Set)this.synNodes.getOrDefault(syn, new HashSet())).add(node);
            }
            this.allSynonyms.addAll(node.getSynonyms());
        }

        public Set<String> getRoots() {
            return this.nodes.stream().filter(node -> node.getParents().isEmpty()).map(node -> node.getId()).collect(Collectors.toSet());
        }

        public void updateNodes() {
            Set<String> roots = this.getRoots();
            for (TaxonomyNode node : this.nodes) {
                this.graph.addVertex(node.id);
            }
            for (TaxonomyNode node : this.nodes) {
                for (String parent : node.parents) {
                    this.graph.addEdge(parent, node.id);
                }
            }
            for (TaxonomyNode node : this.nodes) {
                node.setAncestors(this.graph.getAncestors(node.id));
                for (String root : roots) {
                    for (GraphPath<String, DefaultEdge> path : new AllDirectedPaths<String, DefaultEdge>(this.graph).getAllPaths(root, node.id, true, null)) {
                        List<TaxonomyNode> pathNodes = path.getVertexList().stream().map(nodeId -> this.idNodes.get(nodeId)).collect(Collectors.toList());
                        node.addPath(new TaxonomyNodePath(pathNodes));
                    }
                }
            }
        }

        public void setSearchObjects() {
            for (SearchType searchType : SearchType.values()) {
                boolean plurals = searchType.equals((Object)SearchType.PLURALS) || searchType.equals((Object)SearchType.PLURALS_CASEINSENSITIVE);
                boolean caseSensitive = !searchType.equals((Object)SearchType.CASEINSENSITIVE) && !searchType.equals((Object)SearchType.PLURALS_CASEINSENSITIVE);
                this.searchTaxonomy = new HashMap();
                this.synAliases = new HashMap<String, Set<String>>();
                this.synAdditionalData = new HashMap<String, Map<String, Object>>();
                this.nodes.forEach(node -> {
                    HashSet<String> synSet = new HashSet<String>(node.getSynonyms());
                    node.getSynonyms().forEach(j -> {
                        String pluralS = null;
                        if (plurals) {
                            pluralS = PluralUtils.pluralise(j);
                            synSet.add(pluralS);
                        }
                        if (!caseSensitive) {
                            synSet.add(j.toLowerCase());
                            if (pluralS != null) {
                                synSet.add(pluralS.toLowerCase());
                            }
                        }
                    });
                    this.searchTaxonomy.put(synSet, node.toMap());
                });
                this.searchTaxonomy.forEach((syns, nodeMap) -> syns.forEach(syn1 -> syns.forEach(syn2 -> ((Set)this.synAliases.getOrDefault(syn1, new HashSet())).add(syn2))));
                this.searchTaxonomy.forEach((syns, additionalData) -> syns.forEach(syn -> {
                    Map thisAdditionalData = this.synAdditionalData.getOrDefault(syn, new HashMap());
                    ArrayList ids = thisAdditionalData.getOrDefault("ids", new ArrayList());
                    ArrayList<Map> nodes = thisAdditionalData.getOrDefault("nodes", new ArrayList());
                    ids.add(additionalData.get("id"));
                    nodes.add((Map)additionalData);
                    this.synAdditionalData.put((String)syn, thisAdditionalData);
                    thisAdditionalData.put("ids", ids);
                    thisAdditionalData.put("nodes", nodes);
                }));
                Map searchTypeMap = this.searchData.getOrDefault((Object)searchType, new HashMap());
                this.searchData.put(searchType, searchTypeMap);
                searchTypeMap.put("searchTaxonomy", this.searchTaxonomy);
                searchTypeMap.put("synAliases", this.synAliases);
                searchTypeMap.put("synAdditionalData", this.synAdditionalData);
            }
        }

        private SearchType getSearchType(boolean plurals, boolean caseSensitive) {
            return plurals ? (caseSensitive ? SearchType.PLURALS : SearchType.PLURALS_CASEINSENSITIVE) : (caseSensitive ? SearchType.BASE : SearchType.CASEINSENSITIVE);
        }

        public HashMap<Set<String>, Map<String, Object>> getSearchTaxonomy(boolean plurals, boolean caseSensitive) {
            return (HashMap)this.searchData.get((Object)this.getSearchType(plurals, caseSensitive)).get("searchTaxonomy");
        }

        public Map<String, Set<String>> getSynAliases(boolean plurals, boolean caseSensitive) {
            return (Map)this.searchData.get((Object)this.getSearchType(plurals, caseSensitive)).get("synAliases");
        }

        public Map<String, Map<String, Object>> getSynAdditionalData(boolean plurals, boolean caseSensitive) {
            return (Map)this.searchData.get((Object)this.getSearchType(plurals, caseSensitive)).get("synAdditionalData");
        }

        public void setSynAliases(Map<String, Set<String>> synAliases) {
            this.synAliases = synAliases;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIdField() {
            return this.idField;
        }

        public void setIdField(String idField) {
            this.idField = idField;
        }

        public String getPtField() {
            return this.ptField;
        }

        public void setPtField(String ptField) {
            this.ptField = ptField;
        }

        public Set<String> getSynonymFields() {
            return this.synonymFields;
        }

        public void setSynonymFields(Set<String> synonymFields) {
            this.synonymFields = synonymFields;
        }

        public String getParentsField() {
            return this.parentsField;
        }

        public void setParentsField(String parentsField) {
            this.parentsField = parentsField;
        }

        public Set<String> getAllSynonyms() {
            return this.allSynonyms;
        }

        public void setAllSynonyms(Set<String> allSynonyms) {
            this.allSynonyms = allSynonyms;
        }
    }

    private class TaxonomyNodePath {
        private List<TaxonomyNode> path;

        public TaxonomyNodePath(List<TaxonomyNode> path) {
            this.path = path;
        }

        public String getIdPath() {
            List nodeIds = this.path.stream().map(node -> node.getId()).collect(Collectors.toList());
            return "|" + String.join((CharSequence)"|", nodeIds);
        }

        public String getPtPath() {
            List pts = this.path.stream().map(node -> node.getPreferredTerm()).collect(Collectors.toList());
            return "|" + String.join((CharSequence)"|", pts);
        }
    }

    private class TaxonomyNode {
        private String id;
        private String preferredTerm;
        private Set<String> synonyms;
        private Set<String> ancestors;
        private Set<TaxonomyNodePath> paths;
        private Set<String> parents;

        public TaxonomyNode(String id, String preferredTerm, Set<String> synonyms, Set<String> parents) {
            this.id = id;
            this.preferredTerm = preferredTerm;
            this.synonyms = synonyms;
            this.parents = parents;
            this.paths = new HashSet<TaxonomyNodePath>();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPreferredTerm() {
            return this.preferredTerm;
        }

        public void setPreferredTerm(String preferredTerm) {
            this.preferredTerm = preferredTerm;
        }

        public Set<String> getSynonyms() {
            return this.synonyms;
        }

        public void setSynonyms(Set<String> synonyms) {
            this.synonyms = synonyms;
        }

        public Set<String> getAncestors() {
            return this.ancestors;
        }

        public void setAncestors(Set<String> ancestors) {
            this.ancestors = ancestors;
        }

        public void addPath(TaxonomyNodePath path) {
            this.paths.add(path);
        }

        public Set<String> getParents() {
            return this.parents;
        }

        public void setParents(Set<String> parents) {
            this.parents = parents;
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", this.id);
            map.put("preferredTerm", this.preferredTerm);
            map.put("synonyms", new ArrayList<String>(this.synonyms));
            map.put("ancestors", new ArrayList<String>(this.ancestors));
            map.put("id_paths", this.paths.stream().map(path -> path.getIdPath()).collect(Collectors.toList()));
            map.put("pt_paths", this.paths.stream().map(path -> path.getPtPath()).collect(Collectors.toList()));
            map.put("parents", this.parents);
            return map;
        }
    }

    static enum SearchType {
        BASE,
        PLURALS,
        CASEINSENSITIVE,
        PLURALS_CASEINSENSITIVE;

    }
}

