/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.pipeline;

import io.annot8.api.components.responses.SourceResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.ItemFactory;
import io.annot8.api.pipelines.Pipeline;
import io.annot8.api.pipelines.PipelineDescriptor;
import io.annot8.api.pipelines.PipelineRunner;
import io.annot8.common.components.logging.Logging;
import io.annot8.common.components.metering.Metering;
import io.annot8.common.components.metering.Metrics;
import io.annot8.common.components.metering.NoOpMetrics;
import io.annot8.implementations.pipeline.SimplePipeline;
import io.annot8.implementations.support.stores.QueueItemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryPipelineRunner
implements PipelineRunner {
    private static final long DEFAULT_DELAY = 1000L;
    private final Pipeline pipeline;
    private final Logger logger;
    private final Metrics metrics;
    private final QueueItemFactory itemFactory;
    private final long delay;
    private boolean running = true;

    public InMemoryPipelineRunner(Pipeline pipeline, ItemFactory itemFactory) {
        this(pipeline, itemFactory, 1000L);
    }

    public InMemoryPipelineRunner(Pipeline pipeline, ItemFactory itemFactory, long delay) {
        this.pipeline = pipeline;
        this.logger = pipeline.getContext().getResource(Logging.class).map(l -> l.getLogger(InMemoryPipelineRunner.class)).orElse(LoggerFactory.getLogger(InMemoryPipelineRunner.class));
        this.metrics = pipeline.getContext().getResource(Metering.class).map(value -> value.getMetrics("pipeline")).orElseGet(NoOpMetrics::instance);
        this.itemFactory = new QueueItemFactory(itemFactory);
        this.itemFactory.register(i -> this.logger.debug("Item {} added to queue", (Object)i.getId()));
        this.delay = delay;
    }

    public InMemoryPipelineRunner(PipelineDescriptor pipelineDescriptor, ItemFactory itemFactory) {
        this(new SimplePipeline.Builder().from(pipelineDescriptor).build(), itemFactory, 1000L);
    }

    public InMemoryPipelineRunner(PipelineDescriptor pipelineDescriptor, ItemFactory itemFactory, long delay) {
        this(new SimplePipeline.Builder().from(pipelineDescriptor).build(), itemFactory, delay);
    }

    public InMemoryPipelineRunner(PipelineDescriptor pipelineDescriptor, ItemFactory itemFactory, Context context) {
        this(new SimplePipeline.Builder().from(pipelineDescriptor).withContext(context).build(), itemFactory, 1000L);
    }

    public InMemoryPipelineRunner(PipelineDescriptor pipelineDescriptor, ItemFactory itemFactory, Context context, long delay) {
        this(new SimplePipeline.Builder().from(pipelineDescriptor).withContext(context).build(), itemFactory, delay);
    }

    @Override
    public void run() {
        this.logger.info("Pipeline {} started", (Object)this.pipeline.getName());
        this.running = true;
        Long startTime = this.metrics.gauge("runTime", System.currentTimeMillis(), t -> System.currentTimeMillis() - t);
        this.logger.debug("Pipeline {} started at {}", (Object)this.pipeline.getName(), (Object)startTime);
        while (this.running) {
            SourceResponse sr = this.pipeline.read(this.itemFactory);
            while (this.running && !this.itemFactory.isEmpty()) {
                this.metrics.timer("itemProcessingTime", new String[0]).record(() -> this.itemFactory.next().ifPresent(this.pipeline::process));
                this.metrics.counter("itemsProcessed", new String[0]).increment();
            }
            if (sr.getStatus() == SourceResponse.Status.DONE) {
                this.stop();
            }
            if (this.delay <= 0L) continue;
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                this.logger.debug("Sleep interrupted - {}", (Object)e.getMessage());
            }
        }
        this.logger.debug("Pipeline {} finished at {}", (Object)this.pipeline.getName(), (Object)startTime);
        this.logger.info("Pipeline {} ran for {} seconds", (Object)this.pipeline.getName(), (Object)((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    @Override
    public void stop() {
        this.logger.info("Stopping pipeline after current item/source");
        this.running = false;
    }
}

