/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.reference.annotations;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.exceptions.IncompleteException;
import io.annot8.api.properties.ImmutableProperties;
import io.annot8.api.properties.MutableProperties;
import io.annot8.api.properties.Properties;
import io.annot8.common.data.properties.EmptyImmutableProperties;
import io.annot8.implementations.support.annotations.AbstractAnnotation;
import io.annot8.implementations.support.properties.MapImmutableProperties;
import io.annot8.implementations.support.properties.MapMutableProperties;
import java.util.Optional;
import java.util.UUID;

public class DefaultAnnotation
extends AbstractAnnotation {
    private final String id;
    private final String type;
    private final ImmutableProperties properties;
    private final Bounds bounds;
    private final String contentId;

    private DefaultAnnotation(String id, String type, ImmutableProperties properties, Bounds bounds, String contentId) {
        this.id = id;
        this.type = type;
        this.properties = properties;
        this.bounds = bounds;
        this.contentId = contentId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public ImmutableProperties getProperties() {
        return this.properties;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    public static class Builder
    implements Annotation.Builder {
        private final String contentId;
        private String type = null;
        private MutableProperties properties = new MapMutableProperties();
        private Bounds bounds = null;
        private String id = null;

        public Builder(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public Annotation.Builder withId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Annotation.Builder withType(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Annotation.Builder withProperty(String key, Object value) {
            this.properties.set(key, value);
            return this;
        }

        @Override
        public Annotation.Builder withPropertyIfPresent(String key, Optional<?> value) {
            value.ifPresent(o -> this.properties.set(key, o));
            return this;
        }

        @Override
        public Annotation.Builder withoutProperty(String key, Object value) {
            Optional<Object> val = this.properties.get(key);
            if (val.isPresent() && val.get().equals(value)) {
                this.properties.remove(key);
            }
            return this;
        }

        @Override
        public Annotation.Builder withoutProperty(String key) {
            this.properties.remove(key);
            return this;
        }

        @Override
        public Annotation.Builder withProperties(Properties properties) {
            this.properties = new MapMutableProperties(properties);
            return this;
        }

        @Override
        public Annotation.Builder newId() {
            this.id = null;
            return this;
        }

        @Override
        public Annotation.Builder from(Annotation from) {
            this.id = from.getId();
            this.type = from.getType();
            this.properties = new MapMutableProperties(from.getProperties());
            this.bounds = from.getBounds();
            return this;
        }

        @Override
        public Annotation save() {
            if (this.id == null) {
                this.id = UUID.randomUUID().toString();
            }
            if (this.type == null) {
                throw new IncompleteException("Type has not been set");
            }
            if (this.bounds == null) {
                throw new IncompleteException("Bounds has not been set");
            }
            if (this.contentId == null) {
                throw new IncompleteException("Content ID has not been set");
            }
            ImmutableProperties immutableProperties = this.properties.getAll().isEmpty() ? EmptyImmutableProperties.getInstance() : (ImmutableProperties)new MapImmutableProperties.Builder().from(this.properties).save();
            return new DefaultAnnotation(this.id, this.type, immutableProperties, this.bounds, this.contentId);
        }

        @Override
        public Annotation.Builder withBounds(Bounds bounds) {
            this.bounds = bounds;
            return this;
        }
    }
}

