/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nca.annot8.components.opennlp.service;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.gazetteers.processors.Taxonomy;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.tokenize.SimpleTokenizer;
import opennlp.tools.util.Span;
import uk.gov.nca.elasticsearch.extract.ExtractPlugin;

public class OpenNlpService {
    private ExtractPlugin plugin;
    private TokenNameFinderModel nameFinderModel;
    private Map<String, TokenNameFinderModel> nameModels = new HashMap<String, TokenNameFinderModel>();
    private Map<String, String> modelFile = new HashMap<String, String>();
    private Map<String, Taxonomy.TaxonomyInstance> taxonomies = new HashMap<String, Taxonomy.TaxonomyInstance>();

    public OpenNlpService start(ExtractPlugin plugin) {
        this.plugin = plugin;
        this.modelFile.put("Organization", "en-ner-organization.bin");
        this.modelFile.put("Person", "en-ner-person.bin");
        this.modelFile.put("Location", "en-ner-location.bin");
        for (String key : this.modelFile.keySet()) {
            try {
                this.nameModels.put(key, new TokenNameFinderModel(this.getClass().getResourceAsStream(this.modelFile.get(key))));
            }
            catch (IOException e) {
                throw new BadConfigurationException("Unable to load " + key + " model");
            }
        }
        return this;
    }

    public ExtractPlugin getPlugin() {
        return this.plugin;
    }

    public void addTaxonomy(String name, Taxonomy.TaxonomyInstance taxonomy) {
        this.taxonomies.put(name, taxonomy);
    }

    public boolean hasTaxonomy(String name) {
        return this.taxonomies.containsKey(name);
    }

    public Taxonomy.TaxonomyInstance getTaxonomy(String name) {
        return this.taxonomies.get(name);
    }

    public void findEntities(Text content, String nerType, String type) {
        Span[] spans;
        this.nameFinderModel = this.nameModels.get(nerType);
        NameFinderME nameFinder = null;
        nameFinder = new NameFinderME(this.nameFinderModel);
        String contentString = (String)content.getData();
        String[] tokens = SimpleTokenizer.INSTANCE.tokenize(contentString);
        Span[] tokenSpans = SimpleTokenizer.INSTANCE.tokenizePos(contentString);
        for (Span span : spans = nameFinder.find(tokens)) {
            int begin = tokenSpans[span.getStart()].getStart();
            int end = tokenSpans[span.getEnd() - 1].getEnd();
            ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withBounds(new SpanBounds(begin, end)).withType(type)).withProperty("probability", span.getProb())).withProperty("nerType", nerType)).save();
        }
    }
}

