/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nca.annot8.components.regex.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.exceptions.ProcessingException;
import io.annot8.api.stores.AnnotationStore;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractRegexProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

@ComponentName(value="CustomRegex")
@ComponentDescription(value="Extract regex matches using a user-supplied pattern, with case-sensitivity optional")
@SettingsClass(value=Settings.class)
public class CustomRegex
extends AbstractProcessorDescriptor<Processor, Settings> {
    @Override
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withCreatesAnnotations("CustomRegex", SpanBounds.class).withProcessesContent(Text.class).build();
    }

    @Override
    public Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getPattern(), settings.isCaseInsensitive(), settings);
    }

    public static class Processor
    extends AbstractRegexProcessor {
        private String type;

        public Processor(String pattern, boolean caseInsensitive, Settings settings) {
            super(caseInsensitive ? Pattern.compile(pattern, 2) : Pattern.compile(pattern), 0, "CustomRegex");
            this.type = settings.getType();
        }

        @Override
        protected void process(Text content) {
            if (this.pattern == null) {
                throw new BadConfigurationException("Parameter 'pattern' must not be null");
            }
            AnnotationStore annotationStore = content.getAnnotations();
            Matcher m = this.pattern.matcher((CharSequence)content.getData());
            while (m.find()) {
                if (!this.acceptMatch(m)) continue;
                try {
                    Annotation.Builder builder = annotationStore.create();
                    this.addProperties(builder, m);
                    ((Annotation.Builder)builder.withType(this.type)).withBounds(new SpanBounds(m.start(this.group), m.end(this.group))).save();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ProcessingException("Invalid group", e);
                }
            }
        }
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private final String pattern;
        private final boolean caseInsensitive;
        private String type;

        public Settings() {
            this.pattern = null;
            this.caseInsensitive = true;
            this.type = null;
        }

        @JsonbCreator
        public Settings(@JsonbProperty(value="pattern") String pattern, @JsonbProperty(value="caseInsensitive") boolean caseInsensitive, @JsonbProperty(value="type") String type) {
            this.pattern = pattern;
            this.caseInsensitive = caseInsensitive;
            this.type = type;
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean isCaseInsensitive() {
            return this.caseInsensitive;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public boolean validate() {
            return this.pattern != null && this.type != null && this.pattern != "";
        }
    }
}

