/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nca.elasticsearch.extract;

import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.data.ItemFactory;
import io.annot8.api.exceptions.Annot8Exception;
import io.annot8.implementations.reference.content.DefaultText;
import io.annot8.implementations.reference.data.DefaultItem;
import io.annot8.implementations.support.registries.ContentBuilderFactoryRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ingest.IngestDocument;

public class ExtractItemFactory
implements ItemFactory {
    private final ContentBuilderFactoryRegistry contentBuilderFactoryRegistry;
    private Map<String, String> fieldContents = new HashMap<String, String>();

    public ExtractItemFactory(ContentBuilderFactoryRegistry contentBuilderFactoryRegistry) {
        this.contentBuilderFactoryRegistry = contentBuilderFactoryRegistry;
    }

    @Override
    public Item create() {
        DefaultItem item = new DefaultItem(this, this.contentBuilderFactoryRegistry);
        this.applyTextContents(item);
        return item;
    }

    @Override
    public Item create(Item parent) {
        Objects.requireNonNull(parent);
        DefaultItem item = new DefaultItem(parent.getId(), this, this.contentBuilderFactoryRegistry);
        this.applyTextContents(item);
        return item;
    }

    private void applyTextContents(Item item) {
        for (Map.Entry<String, String> entry : this.fieldContents.entrySet()) {
            String field = entry.getKey();
            String content = entry.getValue();
            ((Content.Builder)item.createContent(DefaultText.class).withDescription(field).withId(field)).withData(content).save();
        }
    }

    public void createTextContents(IngestDocument ingestDocument, Set<String> fields) throws Annot8Exception {
        for (String field : fields) {
            String content;
            if (!ingestDocument.hasField(field) || (content = (String)ingestDocument.getFieldValue(field, String.class)) == null) continue;
            this.fieldContents.put(field, content);
        }
    }

    public void clearTextContents() {
        this.fieldContents = new HashMap<String, String>();
    }
}

