/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nca.elasticsearch.extract;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.annot8.api.components.ProcessorDescriptor;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.data.Item;
import io.annot8.api.data.ItemFactory;
import io.annot8.api.exceptions.Annot8Exception;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.pipelines.Pipeline;
import io.annot8.api.pipelines.PipelineDescriptor;
import io.annot8.api.settings.Settings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.components.comms.processors.Telephone;
import io.annot8.components.comms.processors.USTelephone;
import io.annot8.components.cyber.processors.Email;
import io.annot8.components.cyber.processors.IPv4;
import io.annot8.components.cyber.processors.IPv6;
import io.annot8.components.cyber.processors.MacAddress;
import io.annot8.components.cyber.processors.Url;
import io.annot8.components.financial.processors.SortCode;
import io.annot8.components.gazetteers.processors.Taxonomy;
import io.annot8.components.social.processors.HashTag;
import io.annot8.implementations.pipeline.SimplePipeline;
import io.annot8.implementations.pipeline.SimplePipelineDescriptor;
import io.annot8.implementations.reference.content.DefaultText;
import io.annot8.implementations.reference.factories.DefaultContentBuilderFactoryRegistry;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import uk.gov.nca.annot8.components.opennlp.processors.NER;
import uk.gov.nca.annot8.components.opennlp.service.OpenNlpService;
import uk.gov.nca.annot8.components.regex.processors.CustomRegex;
import uk.gov.nca.elasticsearch.extract.ExtractItemFactory;
import uk.gov.nca.elasticsearch.extract.ExtractSettings;
import uk.gov.nca.elasticsearch.extract.ExtractSourceDescriptor;
import uk.gov.nca.elasticsearch.extract.Instances;

public class ExtractProcessor
extends AbstractProcessor {
    public static final String TYPE = "siren-nlp";
    public static final String CONFIG_PROCESS_ALL_FIELDS = "process_all_fields";
    public static final String CONFIG_FIELDS = "fields";
    public static final String CONFIG_TARGET_FIELD = "target_field";
    public static final String CONFIG_PROCESSORS = "processors";
    public static final String START_OFFSET_FIELD = "start_offset_field";
    public static final String END_OFFSET_FIELD = "end_offset_field";
    public static final String COLLAPSE_TAXONOMY_INSTANCES = "collapse_taxonomy_instances";
    public static final String INCLUDE_MATCHES = "include_matches";
    public static final String INCLUDE_IDS = "include_ids";
    public static final String INCLUDE_TAXONOMY_ANNOTATED = "include_taxonomy_annotated";
    public static final String CATEGORIZE_INSTANCES = "categorize_instances_by_type";
    public static final String CATEGORIZE_INSTANCES_BY_FIELD = "categorize_instances_by_field";
    private final Set<String> fields;
    private final boolean allFields;
    private final String targetField;
    private final List<ProcessorDescriptor> processors = new ArrayList<ProcessorDescriptor>();
    private final ItemFactory itemFactory;
    private static final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new ParameterNamesModule());
    private OpenNlpService openNlpService;
    private final String startOffsetField;
    private final String endOffsetField;
    private final boolean collapseTaxonomyInstances;
    private final boolean includeMatches;
    private final boolean includeIds;
    private final boolean includeTaxonomyAnnotated;
    private final boolean categorizeInstances;
    private final boolean categorizeInstancesByField;

    public ExtractProcessor(String tag, String description, ExtractSettings settings, OpenNlpService openNlpService) throws Exception {
        super(tag, description);
        this.fields = settings.getFields();
        this.allFields = settings.isAllFields();
        this.targetField = settings.getTargetField();
        this.openNlpService = openNlpService;
        this.startOffsetField = settings.getStartOffsetField();
        this.endOffsetField = settings.getEndOffsetField();
        this.collapseTaxonomyInstances = settings.isCollapseTaxonomyInstances();
        this.includeMatches = settings.isIncludeMatches();
        this.includeIds = settings.isIncludeIds();
        this.includeTaxonomyAnnotated = settings.isIncludeTaxonomyAnnotated();
        this.categorizeInstances = settings.isCategorizeInstances();
        this.categorizeInstancesByField = settings.isCategorizeInstancesByField();
        DefaultContentBuilderFactoryRegistry contentBuilderFactoryRegistry = new DefaultContentBuilderFactoryRegistry();
        contentBuilderFactoryRegistry.register(DefaultText.class, new DefaultText.BuilderFactory());
        ExtractItemFactory eif = new ExtractItemFactory(contentBuilderFactoryRegistry);
        this.itemFactory = eif;
        for (ExtractSettings.ProcessorSettingsPair psp : settings.getProcessors()) {
            Settings thesesettings = psp.getSettings();
            ProcessorDescriptor p = psp.getProcessor().getConstructor(new Class[0]).newInstance(new Object[0]);
            if (p instanceof NER) {
                ((NER)p).setOpenNlpService(this.openNlpService);
            }
            if (p instanceof Taxonomy) {
                ((Taxonomy)p).setOpenNlpService(this.openNlpService);
            }
            p.setSettings(thesesettings);
            this.processors.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        Item item;
        Set<String> theseFields = this.allFields ? ingestDocument.getSourceAndMetadata().keySet() : this.fields;
        ItemFactory itemFactory = this.itemFactory;
        synchronized (itemFactory) {
            ((ExtractItemFactory)this.itemFactory).createTextContents(ingestDocument, theseFields);
            item = this.itemFactory.create();
            ((ExtractItemFactory)this.itemFactory).clearTextContents();
        }
        PipelineDescriptor pipelineDescriptor = new SimplePipelineDescriptor.Builder().withName("my_pipeline").withDescription("this is my pipeline").withSource(new ExtractSourceDescriptor()).withProcessors(this.processors).build();
        Pipeline pipeline = new SimplePipeline.Builder().from(pipelineDescriptor).build();
        ProcessorResponse response = pipeline.process(item);
        Instances instances = new Instances(this.startOffsetField, this.endOffsetField, theseFields, item, ingestDocument);
        Map<String, Object> extracted = instances.getExtracted(this.includeMatches, this.includeIds, this.includeTaxonomyAnnotated, this.categorizeInstances, this.categorizeInstancesByField, this.collapseTaxonomyInstances);
        ingestDocument.setFieldValue(this.targetField, extracted);
        pipeline.close();
        return ingestDocument;
    }

    private void createTextContents(Item item, IngestDocument ingestDocument, Set<String> fields) throws Annot8Exception {
        for (String field : fields) {
            if (!ingestDocument.hasField(field)) continue;
            String content = (String)ingestDocument.getFieldValue(field, String.class);
            item.createContent(DefaultText.class).withDescription(field).withData(content).save();
        }
    }

    public String getType() {
        return TYPE;
    }

    private static final class ProcessorDefinition {
        private final String clazz;
        private final Map<String, Object> settings;

        public ProcessorDefinition(Map<String, Object> config) {
            if (!config.containsKey("class")) {
                throw new IllegalArgumentException("Property class is required");
            }
            try {
                this.clazz = (String)config.get("class");
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Property class must be a String");
            }
            if (config.containsKey("settings")) {
                try {
                    this.settings = (Map)config.get("settings");
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Property settings must be a Map");
                }
            } else {
                this.settings = Collections.emptyMap();
            }
        }

        public String getClazz() {
            return this.clazz;
        }

        public Map<String, Object> getSettings() {
            return this.settings;
        }
    }

    public static final class Factory
    implements Processor.Factory {
        private OpenNlpService openNlpService;
        private Map<String, Class<? extends AbstractProcessorDescriptor>> processorToClass = new HashMap(){
            {
                this.put("Telephone", Telephone.class);
                this.put("USTelephone", USTelephone.class);
                this.put("Email", Email.class);
                this.put("IPv4", IPv4.class);
                this.put("IPv6", IPv6.class);
                this.put("MacAddress", MacAddress.class);
                this.put("Url", Url.class);
                this.put("SortCode", SortCode.class);
                this.put("HashTag", HashTag.class);
                this.put("NER", NER.class);
                this.put("Taxonomy", Taxonomy.class);
                this.put("CustomRegex", CustomRegex.class);
            }
        };

        Factory(OpenNlpService openNlpService) {
            this.openNlpService = openNlpService;
        }

        public ExtractProcessor create(Map<String, Processor.Factory> factories, String tag, String description, Map<String, Object> config) throws Exception {
            ExtractSettings settings = new ExtractSettings();
            if (config.containsKey(ExtractProcessor.CONFIG_PROCESS_ALL_FIELDS)) {
                boolean allFields = ConfigurationUtils.readBooleanProperty((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.CONFIG_PROCESS_ALL_FIELDS, (boolean)false);
                if (allFields) {
                    settings.withAllFields();
                } else {
                    settings.withFields(ConfigurationUtils.readList((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.CONFIG_FIELDS));
                }
            } else {
                settings.withFields(ConfigurationUtils.readList((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.CONFIG_FIELDS));
            }
            if (config.containsKey(ExtractProcessor.CONFIG_TARGET_FIELD)) {
                settings.withTargetField(ConfigurationUtils.readStringProperty((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.CONFIG_TARGET_FIELD));
            }
            if (config.containsKey(ExtractProcessor.CONFIG_PROCESSORS)) {
                List l = ConfigurationUtils.readList((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.CONFIG_PROCESSORS);
                for (Map o : l) {
                    ProcessorDefinition def = new ProcessorDefinition(o);
                    settings.withProcessorSettingsPair(this.parseProcessorDefinition(def));
                }
            }
            if (config.containsKey(ExtractProcessor.START_OFFSET_FIELD)) {
                settings.withStartOffsetField(ConfigurationUtils.readStringProperty((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.START_OFFSET_FIELD));
            }
            if (config.containsKey(ExtractProcessor.END_OFFSET_FIELD)) {
                settings.withEndOffsetField(ConfigurationUtils.readStringProperty((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.END_OFFSET_FIELD));
            }
            if (config.containsKey(ExtractProcessor.COLLAPSE_TAXONOMY_INSTANCES)) {
                settings.withCollapseTaxonomyInstances(ConfigurationUtils.readBooleanProperty((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.COLLAPSE_TAXONOMY_INSTANCES, (boolean)false));
            }
            if (config.containsKey(ExtractProcessor.INCLUDE_MATCHES)) {
                settings.withIncludeMatches(ConfigurationUtils.readBooleanProperty((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.INCLUDE_MATCHES, (boolean)true));
            }
            if (config.containsKey(ExtractProcessor.INCLUDE_IDS)) {
                settings.withIncludeIds(ConfigurationUtils.readBooleanProperty((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.INCLUDE_IDS, (boolean)true));
            }
            if (config.containsKey(ExtractProcessor.INCLUDE_TAXONOMY_ANNOTATED)) {
                settings.withIncludeTaxonomyAnnotated(ConfigurationUtils.readBooleanProperty((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.INCLUDE_TAXONOMY_ANNOTATED, (boolean)true));
            }
            if (config.containsKey(ExtractProcessor.CATEGORIZE_INSTANCES)) {
                settings.withCategorizeInstances(ConfigurationUtils.readBooleanProperty((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.CATEGORIZE_INSTANCES, (boolean)true));
            }
            if (config.containsKey(ExtractProcessor.CATEGORIZE_INSTANCES_BY_FIELD)) {
                settings.withCategorizeInstancesByField(ConfigurationUtils.readBooleanProperty((String)ExtractProcessor.TYPE, (String)tag, config, (String)ExtractProcessor.CATEGORIZE_INSTANCES_BY_FIELD, (boolean)true));
            }
            return new ExtractProcessor(tag, description, settings, this.openNlpService);
        }

        private ExtractSettings.ProcessorSettingsPair parseProcessorDefinition(ProcessorDefinition def) {
            String defClass = def.getClazz();
            Class processor = this.processorToClass.getOrDefault(defClass, null);
            if (processor == null) {
                throw new BadConfigurationException("Invalid siren-nlp processor name: " + defClass + ". Must be one of" + Arrays.toString(this.processorToClass.keySet().toArray()));
            }
            if (!def.getSettings().isEmpty()) {
                SettingsClass sc = processor.getAnnotation(SettingsClass.class);
                if (sc != null) {
                    Class<? extends Settings> s = sc.value();
                    Settings processorSettings = AccessController.doPrivileged(() -> (Settings)objectMapper.convertValue(def.getSettings(), s));
                    return new ExtractSettings.ProcessorSettingsPair(processor, processorSettings);
                }
            } else {
                return new ExtractSettings.ProcessorSettingsPair(processor);
            }
            return null;
        }
    }
}

