/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nca.elasticsearch.extract;

import io.annot8.api.settings.NoSettings;
import io.annot8.api.settings.Settings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.components.comms.processors.Telephone;
import io.annot8.components.comms.processors.USTelephone;
import io.annot8.components.cyber.processors.Email;
import io.annot8.components.cyber.processors.IPv4;
import io.annot8.components.cyber.processors.IPv6;
import io.annot8.components.cyber.processors.MacAddress;
import io.annot8.components.cyber.processors.Url;
import io.annot8.components.financial.processors.SortCode;
import io.annot8.components.social.processors.HashTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.gov.nca.annot8.components.opennlp.processors.NER;

public class ExtractSettings {
    public static final boolean DEFAULT_PROCESS_ALL_FIELDS = false;
    public static final String DEFAULT_TARGET_FIELD = "siren.nlp";
    public static final String DEFAULT_START_OFFSET_FIELD = "start";
    public static final String DEFAULT_END_OFFSET_FIELD = "end";
    public static final boolean DEFAULT_COLLAPSE_TAXONOMY_INSTANCES = false;
    public static final boolean DEFAULT_INCLUDE_MATCHES = true;
    public static final boolean DEFAULT_INCLUDE_IDS = true;
    public static final boolean DEFAULT_INCLUDE_TAXONOMY_ANNOTATED = true;
    public static final boolean DEFAULT_CATEGORIZE_INSTANCES = true;
    public static final boolean DEFAULT_CATEGORIZE_INSTANCES_BY_FIELD = true;
    public static final List<ProcessorSettingsPair> DEFAULT_PROCESSORS = Arrays.asList(new ProcessorSettingsPair(Telephone.class, NoSettings.getInstance()), new ProcessorSettingsPair(USTelephone.class, NoSettings.getInstance()), new ProcessorSettingsPair(Email.class, NoSettings.getInstance()), new ProcessorSettingsPair(IPv4.class, NoSettings.getInstance()), new ProcessorSettingsPair(IPv6.class, NoSettings.getInstance()), new ProcessorSettingsPair(MacAddress.class, NoSettings.getInstance()), new ProcessorSettingsPair(Url.class, new Url.Settings(true)), new ProcessorSettingsPair(SortCode.class, NoSettings.getInstance()), new ProcessorSettingsPair(HashTag.class, NoSettings.getInstance()), new ProcessorSettingsPair(NER.class, NER.Settings.getOrganizationInstance()), new ProcessorSettingsPair(NER.class, NER.Settings.getPersonInstance()), new ProcessorSettingsPair(NER.class, NER.Settings.getLocationInstance()));
    private Set<String> fields = new HashSet<String>();
    private boolean allFields = false;
    private String targetField = "siren.nlp";
    private String startOffsetField = "start";
    private String endOffsetField = "end";
    private List<ProcessorSettingsPair> processors = new ArrayList<ProcessorSettingsPair>();
    private boolean collapseTaxonomyInstances = false;
    private boolean includeMatches = true;
    private boolean includeIds = true;
    private boolean includeTaxonomyAnnotated = true;
    private boolean categorizeInstances = true;
    private boolean categorizeInstancesByField = true;

    public ExtractSettings withField(String field) {
        this.fields.add(field);
        this.allFields = false;
        return this;
    }

    public ExtractSettings withFields(Collection<String> fields) {
        this.fields.addAll(fields);
        this.allFields = false;
        return this;
    }

    public ExtractSettings withAllFields() {
        this.fields.clear();
        this.allFields = true;
        return this;
    }

    public ExtractSettings withTargetField(String targetField) {
        this.targetField = targetField;
        return this;
    }

    public ExtractSettings withStartOffsetField(String startOffsetField) {
        this.startOffsetField = startOffsetField;
        return this;
    }

    public ExtractSettings withEndOffsetField(String endOffsetField) {
        this.endOffsetField = endOffsetField;
        return this;
    }

    public ExtractSettings withCollapseTaxonomyInstances(boolean collapseTaxonomyInstances) {
        this.collapseTaxonomyInstances = collapseTaxonomyInstances;
        return this;
    }

    public ExtractSettings withIncludeMatches(boolean includeMatches) {
        this.includeMatches = includeMatches;
        return this;
    }

    public ExtractSettings withIncludeIds(boolean includeIds) {
        this.includeIds = includeIds;
        return this;
    }

    public ExtractSettings withIncludeTaxonomyAnnotated(boolean includeTaxonomyAnnotated) {
        this.includeTaxonomyAnnotated = includeTaxonomyAnnotated;
        return this;
    }

    public ExtractSettings withCategorizeInstances(boolean categorizeInstances) {
        this.categorizeInstances = categorizeInstances;
        return this;
    }

    public ExtractSettings withCategorizeInstancesByField(boolean categorizeInstancesByField) {
        this.categorizeInstancesByField = categorizeInstancesByField;
        return this;
    }

    public ExtractSettings withProcessorSettingsPair(ProcessorSettingsPair pair) {
        this.processors.add(pair);
        return this;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public boolean isAllFields() {
        return this.allFields;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public String getStartOffsetField() {
        return this.startOffsetField;
    }

    public String getEndOffsetField() {
        return this.endOffsetField;
    }

    public boolean isCollapseTaxonomyInstances() {
        return this.collapseTaxonomyInstances;
    }

    public boolean isIncludeMatches() {
        return this.includeMatches;
    }

    public boolean isIncludeIds() {
        return this.includeIds;
    }

    public boolean isIncludeTaxonomyAnnotated() {
        return this.includeTaxonomyAnnotated;
    }

    public boolean isCategorizeInstances() {
        return this.categorizeInstances;
    }

    public boolean isCategorizeInstancesByField() {
        return this.categorizeInstancesByField;
    }

    public List<ProcessorSettingsPair> getProcessors() {
        if (this.processors.isEmpty()) {
            return DEFAULT_PROCESSORS;
        }
        return this.processors;
    }

    static class ProcessorSettingsPair {
        private final Class<? extends AbstractProcessorDescriptor> processor;
        private final Settings processorSettings;

        public ProcessorSettingsPair(Class<? extends AbstractProcessorDescriptor> processor) {
            this.processor = processor;
            this.processorSettings = NoSettings.getInstance();
        }

        public ProcessorSettingsPair(Class<? extends AbstractProcessorDescriptor> processor, Settings settings) {
            this.processor = processor;
            this.processorSettings = settings;
        }

        public Class<? extends AbstractProcessorDescriptor> getProcessor() {
            return this.processor;
        }

        public Settings getSettings() {
            return this.processorSettings;
        }

        public boolean equals(Object obj) {
            if (!ProcessorSettingsPair.class.isInstance(obj)) {
                return false;
            }
            ProcessorSettingsPair psp = (ProcessorSettingsPair)obj;
            return psp.getProcessor().equals(this.processor) && psp.getSettings().equals(this.processorSettings);
        }
    }
}

